package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{FilterExpression, GroupARN, GroupName}
import scala.jdk.CollectionConverters._
final case class UpdateGroupRequest(
    groupName: Option[GroupName] = None,
    groupARN: Option[GroupARN] = None,
    filterExpression: Option[FilterExpression] = None,
    insightsConfiguration: Option[zio.aws.xray.model.InsightsConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.UpdateGroupRequest = {
    import UpdateGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.UpdateGroupRequest
      .builder()
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupARN.map(value => GroupARN.unwrap(value): java.lang.String)
      )(_.groupARN)
      .optionallyWith(
        filterExpression.map(value =>
          FilterExpression.unwrap(value): java.lang.String
        )
      )(_.filterExpression)
      .optionallyWith(
        insightsConfiguration.map(value => value.buildAwsValue())
      )(_.insightsConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.UpdateGroupRequest.ReadOnly =
    zio.aws.xray.model.UpdateGroupRequest.wrap(buildAwsValue())
}
object UpdateGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.UpdateGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.UpdateGroupRequest =
      zio.aws.xray.model.UpdateGroupRequest(
        groupName.map(value => value),
        groupARN.map(value => value),
        filterExpression.map(value => value),
        insightsConfiguration.map(value => value.asEditable)
      )
    def groupName: Option[GroupName]
    def groupARN: Option[GroupARN]
    def filterExpression: Option[FilterExpression]
    def insightsConfiguration
        : Option[zio.aws.xray.model.InsightsConfiguration.ReadOnly]
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupARN: ZIO[Any, AwsError, GroupARN] =
      AwsError.unwrapOptionField("groupARN", groupARN)
    def getFilterExpression: ZIO[Any, AwsError, FilterExpression] =
      AwsError.unwrapOptionField("filterExpression", filterExpression)
    def getInsightsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.xray.model.InsightsConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("insightsConfiguration", insightsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.UpdateGroupRequest
  ) extends zio.aws.xray.model.UpdateGroupRequest.ReadOnly {
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.xray.model.primitives.GroupName(value))
    override val groupARN: Option[GroupARN] = scala
      .Option(impl.groupARN())
      .map(value => zio.aws.xray.model.primitives.GroupARN(value))
    override val filterExpression: Option[FilterExpression] = scala
      .Option(impl.filterExpression())
      .map(value => zio.aws.xray.model.primitives.FilterExpression(value))
    override val insightsConfiguration
        : Option[zio.aws.xray.model.InsightsConfiguration.ReadOnly] = scala
      .Option(impl.insightsConfiguration())
      .map(value => zio.aws.xray.model.InsightsConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.UpdateGroupRequest
  ): zio.aws.xray.model.UpdateGroupRequest.ReadOnly = new Wrapper(impl)
}
