package zio.aws.xray
import zio.aws.xray.model.GetInsightResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.xray.model.{
  GetEncryptionConfigRequest,
  GetTraceGraphRequest,
  BatchGetTracesRequest,
  PutEncryptionConfigRequest,
  GetGroupRequest,
  GetGroupsRequest,
  UpdateGroupRequest,
  CreateSamplingRuleRequest,
  GetInsightEventsRequest,
  ListTagsForResourceRequest,
  DeleteGroupRequest,
  GetServiceGraphRequest,
  GetSamplingRulesRequest,
  GetInsightImpactGraphRequest,
  GetInsightSummariesRequest,
  GetTraceSummariesRequest,
  DeleteSamplingRuleRequest,
  UntagResourceRequest,
  CreateGroupRequest,
  PutTelemetryRecordsRequest,
  GetSamplingStatisticSummariesRequest,
  GetSamplingTargetsRequest,
  GetTimeSeriesServiceStatisticsRequest,
  PutTraceSegmentsRequest,
  GetInsightRequest,
  UpdateSamplingRuleRequest,
  TagResourceRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.xray.XRayAsyncClient
import zio.stream.ZStream
object XRayMock extends Mock[XRay] {
  object GetInsightEvents
      extends Stream[
        GetInsightEventsRequest,
        AwsError,
        zio.aws.xray.model.InsightEvent.ReadOnly
      ]
  object GetInsightEventsPaginated
      extends Effect[
        GetInsightEventsRequest,
        AwsError,
        zio.aws.xray.model.GetInsightEventsResponse.ReadOnly
      ]
  object GetServiceGraph
      extends Effect[GetServiceGraphRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.xray.model.GetServiceGraphResponse.ReadOnly,
        zio.aws.xray.model.Service.ReadOnly
      ]]
  object GetServiceGraphPaginated
      extends Effect[
        GetServiceGraphRequest,
        AwsError,
        zio.aws.xray.model.GetServiceGraphResponse.ReadOnly
      ]
  object BatchGetTraces
      extends Stream[
        BatchGetTracesRequest,
        AwsError,
        zio.aws.xray.model.Trace.ReadOnly
      ]
  object BatchGetTracesPaginated
      extends Effect[
        BatchGetTracesRequest,
        AwsError,
        zio.aws.xray.model.BatchGetTracesResponse.ReadOnly
      ]
  object GetTimeSeriesServiceStatistics
      extends Effect[
        GetTimeSeriesServiceStatisticsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly,
          zio.aws.xray.model.TimeSeriesServiceStatistics.ReadOnly
        ]
      ]
  object GetTimeSeriesServiceStatisticsPaginated
      extends Effect[
        GetTimeSeriesServiceStatisticsRequest,
        AwsError,
        zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly
      ]
  object DeleteGroup
      extends Effect[
        DeleteGroupRequest,
        AwsError,
        zio.aws.xray.model.DeleteGroupResponse.ReadOnly
      ]
  object GetTraceGraph
      extends Stream[
        GetTraceGraphRequest,
        AwsError,
        zio.aws.xray.model.Service.ReadOnly
      ]
  object GetTraceGraphPaginated
      extends Effect[
        GetTraceGraphRequest,
        AwsError,
        zio.aws.xray.model.GetTraceGraphResponse.ReadOnly
      ]
  object GetSamplingStatisticSummaries
      extends Stream[
        GetSamplingStatisticSummariesRequest,
        AwsError,
        zio.aws.xray.model.SamplingStatisticSummary.ReadOnly
      ]
  object GetSamplingStatisticSummariesPaginated
      extends Effect[
        GetSamplingStatisticSummariesRequest,
        AwsError,
        zio.aws.xray.model.GetSamplingStatisticSummariesResponse.ReadOnly
      ]
  object PutTelemetryRecords
      extends Effect[
        PutTelemetryRecordsRequest,
        AwsError,
        zio.aws.xray.model.PutTelemetryRecordsResponse.ReadOnly
      ]
  object CreateSamplingRule
      extends Effect[
        CreateSamplingRuleRequest,
        AwsError,
        zio.aws.xray.model.CreateSamplingRuleResponse.ReadOnly
      ]
  object UpdateSamplingRule
      extends Effect[
        UpdateSamplingRuleRequest,
        AwsError,
        zio.aws.xray.model.UpdateSamplingRuleResponse.ReadOnly
      ]
  object GetInsightImpactGraph
      extends Effect[
        GetInsightImpactGraphRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly,
          zio.aws.xray.model.InsightImpactGraphService.ReadOnly
        ]
      ]
  object GetInsightImpactGraphPaginated
      extends Effect[
        GetInsightImpactGraphRequest,
        AwsError,
        zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly
      ]
  object DeleteSamplingRule
      extends Effect[
        DeleteSamplingRuleRequest,
        AwsError,
        zio.aws.xray.model.DeleteSamplingRuleResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.xray.model.UntagResourceResponse.ReadOnly
      ]
  object GetSamplingTargets
      extends Effect[
        GetSamplingTargetsRequest,
        AwsError,
        zio.aws.xray.model.GetSamplingTargetsResponse.ReadOnly
      ]
  object PutEncryptionConfig
      extends Effect[
        PutEncryptionConfigRequest,
        AwsError,
        zio.aws.xray.model.PutEncryptionConfigResponse.ReadOnly
      ]
  object CreateGroup
      extends Effect[
        CreateGroupRequest,
        AwsError,
        zio.aws.xray.model.CreateGroupResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.xray.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.xray.model.ListTagsForResourceResponse.ReadOnly
      ]
  object UpdateGroup
      extends Effect[
        UpdateGroupRequest,
        AwsError,
        zio.aws.xray.model.UpdateGroupResponse.ReadOnly
      ]
  object GetTraceSummaries
      extends Effect[GetTraceSummariesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly,
        zio.aws.xray.model.TraceSummary.ReadOnly
      ]]
  object GetTraceSummariesPaginated
      extends Effect[
        GetTraceSummariesRequest,
        AwsError,
        zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.xray.model.TagResourceResponse.ReadOnly
      ]
  object GetGroup
      extends Effect[
        GetGroupRequest,
        AwsError,
        zio.aws.xray.model.GetGroupResponse.ReadOnly
      ]
  object GetInsight extends Effect[GetInsightRequest, AwsError, ReadOnly]
  object GetEncryptionConfig
      extends Effect[
        GetEncryptionConfigRequest,
        AwsError,
        zio.aws.xray.model.GetEncryptionConfigResponse.ReadOnly
      ]
  object PutTraceSegments
      extends Effect[
        PutTraceSegmentsRequest,
        AwsError,
        zio.aws.xray.model.PutTraceSegmentsResponse.ReadOnly
      ]
  object GetSamplingRules
      extends Stream[
        GetSamplingRulesRequest,
        AwsError,
        zio.aws.xray.model.SamplingRuleRecord.ReadOnly
      ]
  object GetSamplingRulesPaginated
      extends Effect[
        GetSamplingRulesRequest,
        AwsError,
        zio.aws.xray.model.GetSamplingRulesResponse.ReadOnly
      ]
  object GetInsightSummaries
      extends Stream[
        GetInsightSummariesRequest,
        AwsError,
        zio.aws.xray.model.InsightSummary.ReadOnly
      ]
  object GetInsightSummariesPaginated
      extends Effect[
        GetInsightSummariesRequest,
        AwsError,
        zio.aws.xray.model.GetInsightSummariesResponse.ReadOnly
      ]
  object GetGroups
      extends Stream[
        GetGroupsRequest,
        AwsError,
        zio.aws.xray.model.GroupSummary.ReadOnly
      ]
  object GetGroupsPaginated
      extends Effect[
        GetGroupsRequest,
        AwsError,
        zio.aws.xray.model.GetGroupsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, XRay] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new XRay {
          val api: XRayAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : XRay = this
          def getInsightEvents(
              request: GetInsightEventsRequest
          ): ZStream[Any, AwsError, zio.aws.xray.model.InsightEvent.ReadOnly] =
            rts.unsafeRun(proxy(GetInsightEvents, request))
          def getInsightEventsPaginated(request: GetInsightEventsRequest): IO[
            AwsError,
            zio.aws.xray.model.GetInsightEventsResponse.ReadOnly
          ] = proxy(GetInsightEventsPaginated, request)
          def getServiceGraph(
              request: GetServiceGraphRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.xray.model.GetServiceGraphResponse.ReadOnly,
            zio.aws.xray.model.Service.ReadOnly
          ]] = proxy(GetServiceGraph, request)
          def getServiceGraphPaginated(
              request: GetServiceGraphRequest
          ): IO[AwsError, zio.aws.xray.model.GetServiceGraphResponse.ReadOnly] =
            proxy(GetServiceGraphPaginated, request)
          def batchGetTraces(
              request: BatchGetTracesRequest
          ): ZStream[Any, AwsError, zio.aws.xray.model.Trace.ReadOnly] =
            rts.unsafeRun(proxy(BatchGetTraces, request))
          def batchGetTracesPaginated(
              request: BatchGetTracesRequest
          ): IO[AwsError, zio.aws.xray.model.BatchGetTracesResponse.ReadOnly] =
            proxy(BatchGetTracesPaginated, request)
          def getTimeSeriesServiceStatistics(
              request: GetTimeSeriesServiceStatisticsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly,
            zio.aws.xray.model.TimeSeriesServiceStatistics.ReadOnly
          ]] = proxy(GetTimeSeriesServiceStatistics, request)
          def getTimeSeriesServiceStatisticsPaginated(
              request: GetTimeSeriesServiceStatisticsRequest
          ): IO[
            AwsError,
            zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly
          ] = proxy(GetTimeSeriesServiceStatisticsPaginated, request)
          def deleteGroup(
              request: DeleteGroupRequest
          ): IO[AwsError, zio.aws.xray.model.DeleteGroupResponse.ReadOnly] =
            proxy(DeleteGroup, request)
          def getTraceGraph(
              request: GetTraceGraphRequest
          ): ZStream[Any, AwsError, zio.aws.xray.model.Service.ReadOnly] =
            rts.unsafeRun(proxy(GetTraceGraph, request))
          def getTraceGraphPaginated(
              request: GetTraceGraphRequest
          ): IO[AwsError, zio.aws.xray.model.GetTraceGraphResponse.ReadOnly] =
            proxy(GetTraceGraphPaginated, request)
          def getSamplingStatisticSummaries(
              request: GetSamplingStatisticSummariesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.xray.model.SamplingStatisticSummary.ReadOnly
          ] = rts.unsafeRun(proxy(GetSamplingStatisticSummaries, request))
          def getSamplingStatisticSummariesPaginated(
              request: GetSamplingStatisticSummariesRequest
          ): IO[
            AwsError,
            zio.aws.xray.model.GetSamplingStatisticSummariesResponse.ReadOnly
          ] = proxy(GetSamplingStatisticSummariesPaginated, request)
          def putTelemetryRecords(request: PutTelemetryRecordsRequest): IO[
            AwsError,
            zio.aws.xray.model.PutTelemetryRecordsResponse.ReadOnly
          ] = proxy(PutTelemetryRecords, request)
          def createSamplingRule(request: CreateSamplingRuleRequest): IO[
            AwsError,
            zio.aws.xray.model.CreateSamplingRuleResponse.ReadOnly
          ] = proxy(CreateSamplingRule, request)
          def updateSamplingRule(request: UpdateSamplingRuleRequest): IO[
            AwsError,
            zio.aws.xray.model.UpdateSamplingRuleResponse.ReadOnly
          ] = proxy(UpdateSamplingRule, request)
          def getInsightImpactGraph(
              request: GetInsightImpactGraphRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly,
            zio.aws.xray.model.InsightImpactGraphService.ReadOnly
          ]] = proxy(GetInsightImpactGraph, request)
          def getInsightImpactGraphPaginated(
              request: GetInsightImpactGraphRequest
          ): IO[
            AwsError,
            zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly
          ] = proxy(GetInsightImpactGraphPaginated, request)
          def deleteSamplingRule(request: DeleteSamplingRuleRequest): IO[
            AwsError,
            zio.aws.xray.model.DeleteSamplingRuleResponse.ReadOnly
          ] = proxy(DeleteSamplingRule, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.xray.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def getSamplingTargets(request: GetSamplingTargetsRequest): IO[
            AwsError,
            zio.aws.xray.model.GetSamplingTargetsResponse.ReadOnly
          ] = proxy(GetSamplingTargets, request)
          def putEncryptionConfig(request: PutEncryptionConfigRequest): IO[
            AwsError,
            zio.aws.xray.model.PutEncryptionConfigResponse.ReadOnly
          ] = proxy(PutEncryptionConfig, request)
          def createGroup(
              request: CreateGroupRequest
          ): IO[AwsError, zio.aws.xray.model.CreateGroupResponse.ReadOnly] =
            proxy(CreateGroup, request)
          def listTagsForResource(
              request: ListTagsForResourceRequest
          ): ZStream[Any, AwsError, zio.aws.xray.model.Tag.ReadOnly] =
            rts.unsafeRun(proxy(ListTagsForResource, request))
          def listTagsForResourcePaginated(
              request: ListTagsForResourceRequest
          ): IO[
            AwsError,
            zio.aws.xray.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResourcePaginated, request)
          def updateGroup(
              request: UpdateGroupRequest
          ): IO[AwsError, zio.aws.xray.model.UpdateGroupResponse.ReadOnly] =
            proxy(UpdateGroup, request)
          def getTraceSummaries(
              request: GetTraceSummariesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly,
            zio.aws.xray.model.TraceSummary.ReadOnly
          ]] = proxy(GetTraceSummaries, request)
          def getTraceSummariesPaginated(request: GetTraceSummariesRequest): IO[
            AwsError,
            zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly
          ] = proxy(GetTraceSummariesPaginated, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.xray.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def getGroup(
              request: GetGroupRequest
          ): IO[AwsError, zio.aws.xray.model.GetGroupResponse.ReadOnly] =
            proxy(GetGroup, request)
          def getInsight(request: GetInsightRequest): IO[AwsError, ReadOnly] =
            proxy(GetInsight, request)
          def getEncryptionConfig(request: GetEncryptionConfigRequest): IO[
            AwsError,
            zio.aws.xray.model.GetEncryptionConfigResponse.ReadOnly
          ] = proxy(GetEncryptionConfig, request)
          def putTraceSegments(request: PutTraceSegmentsRequest): IO[
            AwsError,
            zio.aws.xray.model.PutTraceSegmentsResponse.ReadOnly
          ] = proxy(PutTraceSegments, request)
          def getSamplingRules(request: GetSamplingRulesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.xray.model.SamplingRuleRecord.ReadOnly
          ] = rts.unsafeRun(proxy(GetSamplingRules, request))
          def getSamplingRulesPaginated(request: GetSamplingRulesRequest): IO[
            AwsError,
            zio.aws.xray.model.GetSamplingRulesResponse.ReadOnly
          ] = proxy(GetSamplingRulesPaginated, request)
          def getInsightSummaries(request: GetInsightSummariesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.xray.model.InsightSummary.ReadOnly
          ] = rts.unsafeRun(proxy(GetInsightSummaries, request))
          def getInsightSummariesPaginated(
              request: GetInsightSummariesRequest
          ): IO[
            AwsError,
            zio.aws.xray.model.GetInsightSummariesResponse.ReadOnly
          ] = proxy(GetInsightSummariesPaginated, request)
          def getGroups(
              request: GetGroupsRequest
          ): ZStream[Any, AwsError, zio.aws.xray.model.GroupSummary.ReadOnly] =
            rts.unsafeRun(proxy(GetGroups, request))
          def getGroupsPaginated(
              request: GetGroupsRequest
          ): IO[AwsError, zio.aws.xray.model.GetGroupsResponse.ReadOnly] =
            proxy(GetGroupsPaginated, request)
        }
      }
    }
  }
}
