package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{NullableBoolean, NullableDouble}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnnotationValue(
    numberValue: Optional[NullableDouble] = Optional.Absent,
    booleanValue: Optional[NullableBoolean] = Optional.Absent,
    stringValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.AnnotationValue = {
    import AnnotationValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.AnnotationValue
      .builder()
      .optionallyWith(numberValue.map(value => value: java.lang.Double))(
        _.numberValue
      )
      .optionallyWith(booleanValue.map(value => value: java.lang.Boolean))(
        _.booleanValue
      )
      .optionallyWith(stringValue.map(value => value: java.lang.String))(
        _.stringValue
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.AnnotationValue.ReadOnly =
    zio.aws.xray.model.AnnotationValue.wrap(buildAwsValue())
}
object AnnotationValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.AnnotationValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.AnnotationValue =
      zio.aws.xray.model.AnnotationValue(
        numberValue.map(value => value),
        booleanValue.map(value => value),
        stringValue.map(value => value)
      )
    def numberValue: Optional[NullableDouble]
    def booleanValue: Optional[NullableBoolean]
    def stringValue: Optional[String]
    def getNumberValue: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("numberValue", numberValue)
    def getBooleanValue: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
    def getStringValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stringValue", stringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.AnnotationValue
  ) extends zio.aws.xray.model.AnnotationValue.ReadOnly {
    override val numberValue: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.numberValue())
      .map(value => value: NullableDouble)
    override val booleanValue: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.booleanValue())
      .map(value => value: NullableBoolean)
    override val stringValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stringValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.AnnotationValue
  ): zio.aws.xray.model.AnnotationValue.ReadOnly = new Wrapper(impl)
}
