package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.TraceId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetTracesRequest(
    traceIds: Iterable[TraceId],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.BatchGetTracesRequest = {
    import BatchGetTracesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.BatchGetTracesRequest
      .builder()
      .traceIds(traceIds.map { item =>
        TraceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.BatchGetTracesRequest.ReadOnly =
    zio.aws.xray.model.BatchGetTracesRequest.wrap(buildAwsValue())
}
object BatchGetTracesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.BatchGetTracesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.BatchGetTracesRequest =
      zio.aws.xray.model
        .BatchGetTracesRequest(traceIds, nextToken.map(value => value))
    def traceIds: List[TraceId]
    def nextToken: Optional[String]
    def getTraceIds: ZIO[Any, Nothing, List[TraceId]] = ZIO.succeed(traceIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.BatchGetTracesRequest
  ) extends zio.aws.xray.model.BatchGetTracesRequest.ReadOnly {
    override val traceIds: List[TraceId] = impl
      .traceIds()
      .asScala
      .map { item =>
        zio.aws.xray.model.primitives.TraceId(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.BatchGetTracesRequest
  ): zio.aws.xray.model.BatchGetTracesRequest.ReadOnly = new Wrapper(impl)
}
