package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{FilterExpression, GroupName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateGroupRequest(
    groupName: GroupName,
    filterExpression: Optional[FilterExpression] = Optional.Absent,
    insightsConfiguration: Optional[zio.aws.xray.model.InsightsConfiguration] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.xray.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.CreateGroupRequest = {
    import CreateGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.CreateGroupRequest
      .builder()
      .groupName(GroupName.unwrap(groupName): java.lang.String)
      .optionallyWith(
        filterExpression.map(value =>
          FilterExpression.unwrap(value): java.lang.String
        )
      )(_.filterExpression)
      .optionallyWith(
        insightsConfiguration.map(value => value.buildAwsValue())
      )(_.insightsConfiguration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.CreateGroupRequest.ReadOnly =
    zio.aws.xray.model.CreateGroupRequest.wrap(buildAwsValue())
}
object CreateGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.CreateGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.CreateGroupRequest =
      zio.aws.xray.model.CreateGroupRequest(
        groupName,
        filterExpression.map(value => value),
        insightsConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def groupName: GroupName
    def filterExpression: Optional[FilterExpression]
    def insightsConfiguration
        : Optional[zio.aws.xray.model.InsightsConfiguration.ReadOnly]
    def tags: Optional[List[zio.aws.xray.model.Tag.ReadOnly]]
    def getGroupName: ZIO[Any, Nothing, GroupName] = ZIO.succeed(groupName)
    def getFilterExpression: ZIO[Any, AwsError, FilterExpression] =
      AwsError.unwrapOptionField("filterExpression", filterExpression)
    def getInsightsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.xray.model.InsightsConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("insightsConfiguration", insightsConfiguration)
    def getTags: ZIO[Any, AwsError, List[zio.aws.xray.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.CreateGroupRequest
  ) extends zio.aws.xray.model.CreateGroupRequest.ReadOnly {
    override val groupName: GroupName =
      zio.aws.xray.model.primitives.GroupName(impl.groupName())
    override val filterExpression: Optional[FilterExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterExpression())
        .map(value => zio.aws.xray.model.primitives.FilterExpression(value))
    override val insightsConfiguration
        : Optional[zio.aws.xray.model.InsightsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insightsConfiguration())
        .map(value => zio.aws.xray.model.InsightsConfiguration.wrap(value))
    override val tags: Optional[List[zio.aws.xray.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.CreateGroupRequest
  ): zio.aws.xray.model.CreateGroupRequest.ReadOnly = new Wrapper(impl)
}
