package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSamplingRuleRequest(
    samplingRule: zio.aws.xray.model.SamplingRule,
    tags: Optional[Iterable[zio.aws.xray.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.CreateSamplingRuleRequest = {
    import CreateSamplingRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.CreateSamplingRuleRequest
      .builder()
      .samplingRule(samplingRule.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.CreateSamplingRuleRequest.ReadOnly =
    zio.aws.xray.model.CreateSamplingRuleRequest.wrap(buildAwsValue())
}
object CreateSamplingRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.CreateSamplingRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.CreateSamplingRuleRequest =
      zio.aws.xray.model.CreateSamplingRuleRequest(
        samplingRule.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def samplingRule: zio.aws.xray.model.SamplingRule.ReadOnly
    def tags: Optional[List[zio.aws.xray.model.Tag.ReadOnly]]
    def getSamplingRule
        : ZIO[Any, Nothing, zio.aws.xray.model.SamplingRule.ReadOnly] =
      ZIO.succeed(samplingRule)
    def getTags: ZIO[Any, AwsError, List[zio.aws.xray.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.CreateSamplingRuleRequest
  ) extends zio.aws.xray.model.CreateSamplingRuleRequest.ReadOnly {
    override val samplingRule: zio.aws.xray.model.SamplingRule.ReadOnly =
      zio.aws.xray.model.SamplingRule.wrap(impl.samplingRule())
    override val tags: Optional[List[zio.aws.xray.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.CreateSamplingRuleRequest
  ): zio.aws.xray.model.CreateSamplingRuleRequest.ReadOnly = new Wrapper(impl)
}
