package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteSamplingRuleRequest(
    ruleName: Optional[String] = Optional.Absent,
    ruleARN: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest = {
    import DeleteSamplingRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest
      .builder()
      .optionallyWith(ruleName.map(value => value: java.lang.String))(
        _.ruleName
      )
      .optionallyWith(ruleARN.map(value => value: java.lang.String))(_.ruleARN)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.DeleteSamplingRuleRequest.ReadOnly =
    zio.aws.xray.model.DeleteSamplingRuleRequest.wrap(buildAwsValue())
}
object DeleteSamplingRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.DeleteSamplingRuleRequest =
      zio.aws.xray.model.DeleteSamplingRuleRequest(
        ruleName.map(value => value),
        ruleARN.map(value => value)
      )
    def ruleName: Optional[String]
    def ruleARN: Optional[String]
    def getRuleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getRuleARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleARN", ruleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest
  ) extends zio.aws.xray.model.DeleteSamplingRuleRequest.ReadOnly {
    override val ruleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleName())
      .map(value => value: String)
    override val ruleARN: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleARN())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest
  ): zio.aws.xray.model.DeleteSamplingRuleRequest.ReadOnly = new Wrapper(impl)
}
