package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EncryptionConfig(
    keyId: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.xray.model.EncryptionStatus] = Optional.Absent,
    `type`: Optional[zio.aws.xray.model.EncryptionType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.EncryptionConfig = {
    import EncryptionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.EncryptionConfig
      .builder()
      .optionallyWith(keyId.map(value => value: java.lang.String))(_.keyId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.EncryptionConfig.ReadOnly =
    zio.aws.xray.model.EncryptionConfig.wrap(buildAwsValue())
}
object EncryptionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.EncryptionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.EncryptionConfig =
      zio.aws.xray.model.EncryptionConfig(
        keyId.map(value => value),
        status.map(value => value),
        `type`.map(value => value)
      )
    def keyId: Optional[String]
    def status: Optional[zio.aws.xray.model.EncryptionStatus]
    def `type`: Optional[zio.aws.xray.model.EncryptionType]
    def getKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getStatus: ZIO[Any, AwsError, zio.aws.xray.model.EncryptionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.xray.model.EncryptionType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.EncryptionConfig
  ) extends zio.aws.xray.model.EncryptionConfig.ReadOnly {
    override val keyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => value: String)
    override val status: Optional[zio.aws.xray.model.EncryptionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.xray.model.EncryptionStatus.wrap(value))
    override val `type`: Optional[zio.aws.xray.model.EncryptionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.xray.model.EncryptionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.EncryptionConfig
  ): zio.aws.xray.model.EncryptionConfig.ReadOnly = new Wrapper(impl)
}
