package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableLong
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ErrorStatistics(
    throttleCount: Optional[NullableLong] = Optional.Absent,
    otherCount: Optional[NullableLong] = Optional.Absent,
    totalCount: Optional[NullableLong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.ErrorStatistics = {
    import ErrorStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.ErrorStatistics
      .builder()
      .optionallyWith(throttleCount.map(value => value: java.lang.Long))(
        _.throttleCount
      )
      .optionallyWith(otherCount.map(value => value: java.lang.Long))(
        _.otherCount
      )
      .optionallyWith(totalCount.map(value => value: java.lang.Long))(
        _.totalCount
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.ErrorStatistics.ReadOnly =
    zio.aws.xray.model.ErrorStatistics.wrap(buildAwsValue())
}
object ErrorStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.ErrorStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.ErrorStatistics =
      zio.aws.xray.model.ErrorStatistics(
        throttleCount.map(value => value),
        otherCount.map(value => value),
        totalCount.map(value => value)
      )
    def throttleCount: Optional[NullableLong]
    def otherCount: Optional[NullableLong]
    def totalCount: Optional[NullableLong]
    def getThrottleCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("throttleCount", throttleCount)
    def getOtherCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("otherCount", otherCount)
    def getTotalCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.ErrorStatistics
  ) extends zio.aws.xray.model.ErrorStatistics.ReadOnly {
    override val throttleCount: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.throttleCount())
      .map(value => value: NullableLong)
    override val otherCount: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.otherCount())
      .map(value => value: NullableLong)
    override val totalCount: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => value: NullableLong)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.ErrorStatistics
  ): zio.aws.xray.model.ErrorStatistics.ReadOnly = new Wrapper(impl)
}
