package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableBoolean
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FaultRootCauseEntity(
    name: Optional[String] = Optional.Absent,
    exceptions: Optional[Iterable[zio.aws.xray.model.RootCauseException]] =
      Optional.Absent,
    remote: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.FaultRootCauseEntity = {
    import FaultRootCauseEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.FaultRootCauseEntity
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        exceptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exceptions)
      .optionallyWith(remote.map(value => value: java.lang.Boolean))(_.remote)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.FaultRootCauseEntity.ReadOnly =
    zio.aws.xray.model.FaultRootCauseEntity.wrap(buildAwsValue())
}
object FaultRootCauseEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.FaultRootCauseEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.FaultRootCauseEntity =
      zio.aws.xray.model.FaultRootCauseEntity(
        name.map(value => value),
        exceptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        remote.map(value => value)
      )
    def name: Optional[String]
    def exceptions
        : Optional[List[zio.aws.xray.model.RootCauseException.ReadOnly]]
    def remote: Optional[NullableBoolean]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getExceptions: ZIO[Any, AwsError, List[
      zio.aws.xray.model.RootCauseException.ReadOnly
    ]] = AwsError.unwrapOptionField("exceptions", exceptions)
    def getRemote: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("remote", remote)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.FaultRootCauseEntity
  ) extends zio.aws.xray.model.FaultRootCauseEntity.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val exceptions
        : Optional[List[zio.aws.xray.model.RootCauseException.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exceptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.RootCauseException.wrap(item)
          }.toList
        )
    override val remote: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.remote())
      .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.FaultRootCauseEntity
  ): zio.aws.xray.model.FaultRootCauseEntity.ReadOnly = new Wrapper(impl)
}
