package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableLong
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FaultStatistics(
    otherCount: Optional[NullableLong] = Optional.Absent,
    totalCount: Optional[NullableLong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.FaultStatistics = {
    import FaultStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.FaultStatistics
      .builder()
      .optionallyWith(otherCount.map(value => value: java.lang.Long))(
        _.otherCount
      )
      .optionallyWith(totalCount.map(value => value: java.lang.Long))(
        _.totalCount
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.FaultStatistics.ReadOnly =
    zio.aws.xray.model.FaultStatistics.wrap(buildAwsValue())
}
object FaultStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.FaultStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.FaultStatistics =
      zio.aws.xray.model.FaultStatistics(
        otherCount.map(value => value),
        totalCount.map(value => value)
      )
    def otherCount: Optional[NullableLong]
    def totalCount: Optional[NullableLong]
    def getOtherCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("otherCount", otherCount)
    def getTotalCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.FaultStatistics
  ) extends zio.aws.xray.model.FaultStatistics.ReadOnly {
    override val otherCount: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.otherCount())
      .map(value => value: NullableLong)
    override val totalCount: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => value: NullableLong)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.FaultStatistics
  ): zio.aws.xray.model.FaultStatistics.ReadOnly = new Wrapper(impl)
}
