package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableLong
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ForecastStatistics(
    faultCountHigh: Optional[NullableLong] = Optional.Absent,
    faultCountLow: Optional[NullableLong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.ForecastStatistics = {
    import ForecastStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.ForecastStatistics
      .builder()
      .optionallyWith(faultCountHigh.map(value => value: java.lang.Long))(
        _.faultCountHigh
      )
      .optionallyWith(faultCountLow.map(value => value: java.lang.Long))(
        _.faultCountLow
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.ForecastStatistics.ReadOnly =
    zio.aws.xray.model.ForecastStatistics.wrap(buildAwsValue())
}
object ForecastStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.ForecastStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.ForecastStatistics =
      zio.aws.xray.model.ForecastStatistics(
        faultCountHigh.map(value => value),
        faultCountLow.map(value => value)
      )
    def faultCountHigh: Optional[NullableLong]
    def faultCountLow: Optional[NullableLong]
    def getFaultCountHigh: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("faultCountHigh", faultCountHigh)
    def getFaultCountLow: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("faultCountLow", faultCountLow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.ForecastStatistics
  ) extends zio.aws.xray.model.ForecastStatistics.ReadOnly {
    override val faultCountHigh: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.faultCountHigh())
      .map(value => value: NullableLong)
    override val faultCountLow: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.faultCountLow())
      .map(value => value: NullableLong)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.ForecastStatistics
  ): zio.aws.xray.model.ForecastStatistics.ReadOnly = new Wrapper(impl)
}
