package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetEncryptionConfigResponse(
    encryptionConfig: Optional[zio.aws.xray.model.EncryptionConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse = {
    import GetEncryptionConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse
      .builder()
      .optionallyWith(encryptionConfig.map(value => value.buildAwsValue()))(
        _.encryptionConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetEncryptionConfigResponse.ReadOnly =
    zio.aws.xray.model.GetEncryptionConfigResponse.wrap(buildAwsValue())
}
object GetEncryptionConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetEncryptionConfigResponse =
      zio.aws.xray.model.GetEncryptionConfigResponse(
        encryptionConfig.map(value => value.asEditable)
      )
    def encryptionConfig: Optional[zio.aws.xray.model.EncryptionConfig.ReadOnly]
    def getEncryptionConfig
        : ZIO[Any, AwsError, zio.aws.xray.model.EncryptionConfig.ReadOnly] =
      AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse
  ) extends zio.aws.xray.model.GetEncryptionConfigResponse.ReadOnly {
    override val encryptionConfig
        : Optional[zio.aws.xray.model.EncryptionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfig())
        .map(value => zio.aws.xray.model.EncryptionConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse
  ): zio.aws.xray.model.GetEncryptionConfigResponse.ReadOnly = new Wrapper(impl)
}
