package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetGroupResponse(
    group: Optional[zio.aws.xray.model.Group] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetGroupResponse = {
    import GetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetGroupResponse
      .builder()
      .optionallyWith(group.map(value => value.buildAwsValue()))(_.group)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetGroupResponse.ReadOnly =
    zio.aws.xray.model.GetGroupResponse.wrap(buildAwsValue())
}
object GetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetGroupResponse =
      zio.aws.xray.model.GetGroupResponse(group.map(value => value.asEditable))
    def group: Optional[zio.aws.xray.model.Group.ReadOnly]
    def getGroup: ZIO[Any, AwsError, zio.aws.xray.model.Group.ReadOnly] =
      AwsError.unwrapOptionField("group", group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetGroupResponse
  ) extends zio.aws.xray.model.GetGroupResponse.ReadOnly {
    override val group: Optional[zio.aws.xray.model.Group.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.group())
        .map(value => zio.aws.xray.model.Group.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetGroupResponse
  ): zio.aws.xray.model.GetGroupResponse.ReadOnly = new Wrapper(impl)
}
