package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.GetGroupsNextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetGroupsRequest(
    nextToken: Optional[GetGroupsNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetGroupsRequest = {
    import GetGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value =>
          GetGroupsNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetGroupsRequest.ReadOnly =
    zio.aws.xray.model.GetGroupsRequest.wrap(buildAwsValue())
}
object GetGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetGroupsRequest =
      zio.aws.xray.model.GetGroupsRequest(nextToken.map(value => value))
    def nextToken: Optional[GetGroupsNextToken]
    def getNextToken: ZIO[Any, AwsError, GetGroupsNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetGroupsRequest
  ) extends zio.aws.xray.model.GetGroupsRequest.ReadOnly {
    override val nextToken: Optional[GetGroupsNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.xray.model.primitives.GetGroupsNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetGroupsRequest
  ): zio.aws.xray.model.GetGroupsRequest.ReadOnly = new Wrapper(impl)
}
