package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetGroupsResponse(
    groups: Optional[Iterable[zio.aws.xray.model.GroupSummary]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetGroupsResponse = {
    import GetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetGroupsResponse
      .builder()
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetGroupsResponse.ReadOnly =
    zio.aws.xray.model.GetGroupsResponse.wrap(buildAwsValue())
}
object GetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetGroupsResponse =
      zio.aws.xray.model.GetGroupsResponse(
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def groups: Optional[List[zio.aws.xray.model.GroupSummary.ReadOnly]]
    def nextToken: Optional[String]
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.xray.model.GroupSummary.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetGroupsResponse
  ) extends zio.aws.xray.model.GetGroupsResponse.ReadOnly {
    override val groups
        : Optional[List[zio.aws.xray.model.GroupSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.GroupSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetGroupsResponse
  ): zio.aws.xray.model.GetGroupsResponse.ReadOnly = new Wrapper(impl)
}
