package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInsightEventsResponse(
    insightEvents: Optional[Iterable[zio.aws.xray.model.InsightEvent]] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetInsightEventsResponse = {
    import GetInsightEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetInsightEventsResponse
      .builder()
      .optionallyWith(
        insightEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.insightEvents)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetInsightEventsResponse.ReadOnly =
    zio.aws.xray.model.GetInsightEventsResponse.wrap(buildAwsValue())
}
object GetInsightEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetInsightEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetInsightEventsResponse =
      zio.aws.xray.model.GetInsightEventsResponse(
        insightEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def insightEvents: Optional[List[zio.aws.xray.model.InsightEvent.ReadOnly]]
    def nextToken: Optional[Token]
    def getInsightEvents
        : ZIO[Any, AwsError, List[zio.aws.xray.model.InsightEvent.ReadOnly]] =
      AwsError.unwrapOptionField("insightEvents", insightEvents)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetInsightEventsResponse
  ) extends zio.aws.xray.model.GetInsightEventsResponse.ReadOnly {
    override val insightEvents
        : Optional[List[zio.aws.xray.model.InsightEvent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insightEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.InsightEvent.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.xray.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetInsightEventsResponse
  ): zio.aws.xray.model.GetInsightEventsResponse.ReadOnly = new Wrapper(impl)
}
