package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInsightResponse(
    insight: Optional[zio.aws.xray.model.Insight] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetInsightResponse = {
    import GetInsightResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetInsightResponse
      .builder()
      .optionallyWith(insight.map(value => value.buildAwsValue()))(_.insight)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetInsightResponse.ReadOnly =
    zio.aws.xray.model.GetInsightResponse.wrap(buildAwsValue())
}
object GetInsightResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetInsightResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetInsightResponse = zio.aws.xray.model
      .GetInsightResponse(insight.map(value => value.asEditable))
    def insight: Optional[zio.aws.xray.model.Insight.ReadOnly]
    def getInsight: ZIO[Any, AwsError, zio.aws.xray.model.Insight.ReadOnly] =
      AwsError.unwrapOptionField("insight", insight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetInsightResponse
  ) extends zio.aws.xray.model.GetInsightResponse.ReadOnly {
    override val insight: Optional[zio.aws.xray.model.Insight.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insight())
        .map(value => zio.aws.xray.model.Insight.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetInsightResponse
  ): zio.aws.xray.model.GetInsightResponse.ReadOnly = new Wrapper(impl)
}
