package zio.aws.xray.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.{
  Token,
  GetInsightSummariesMaxResults,
  Timestamp,
  GroupARN,
  GroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetInsightSummariesRequest(
    states: Optional[Iterable[zio.aws.xray.model.InsightState]] =
      Optional.Absent,
    groupARN: Optional[GroupARN] = Optional.Absent,
    groupName: Optional[GroupName] = Optional.Absent,
    startTime: Timestamp,
    endTime: Timestamp,
    maxResults: Optional[GetInsightSummariesMaxResults] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest = {
    import GetInsightSummariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest
      .builder()
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .optionallyWith(
        groupARN.map(value => GroupARN.unwrap(value): java.lang.String)
      )(_.groupARN)
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        maxResults.map(value =>
          GetInsightSummariesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetInsightSummariesRequest.ReadOnly =
    zio.aws.xray.model.GetInsightSummariesRequest.wrap(buildAwsValue())
}
object GetInsightSummariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetInsightSummariesRequest =
      zio.aws.xray.model.GetInsightSummariesRequest(
        states.map(value => value),
        groupARN.map(value => value),
        groupName.map(value => value),
        startTime,
        endTime,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def states: Optional[List[zio.aws.xray.model.InsightState]]
    def groupARN: Optional[GroupARN]
    def groupName: Optional[GroupName]
    def startTime: Timestamp
    def endTime: Timestamp
    def maxResults: Optional[GetInsightSummariesMaxResults]
    def nextToken: Optional[Token]
    def getStates: ZIO[Any, AwsError, List[zio.aws.xray.model.InsightState]] =
      AwsError.unwrapOptionField("states", states)
    def getGroupARN: ZIO[Any, AwsError, GroupARN] =
      AwsError.unwrapOptionField("groupARN", groupARN)
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getMaxResults: ZIO[Any, AwsError, GetInsightSummariesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest
  ) extends zio.aws.xray.model.GetInsightSummariesRequest.ReadOnly {
    override val states: Optional[List[zio.aws.xray.model.InsightState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.states())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.InsightState.wrap(item)
          }.toList
        )
    override val groupARN: Optional[GroupARN] = zio.aws.core.internal
      .optionalFromNullable(impl.groupARN())
      .map(value => zio.aws.xray.model.primitives.GroupARN(value))
    override val groupName: Optional[GroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.xray.model.primitives.GroupName(value))
    override val startTime: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.endTime())
    override val maxResults: Optional[GetInsightSummariesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.xray.model.primitives.GetInsightSummariesMaxResults(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.xray.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest
  ): zio.aws.xray.model.GetInsightSummariesRequest.ReadOnly = new Wrapper(impl)
}
