package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInsightSummariesResponse(
    insightSummaries: Optional[Iterable[zio.aws.xray.model.InsightSummary]] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetInsightSummariesResponse = {
    import GetInsightSummariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetInsightSummariesResponse
      .builder()
      .optionallyWith(
        insightSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.insightSummaries)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetInsightSummariesResponse.ReadOnly =
    zio.aws.xray.model.GetInsightSummariesResponse.wrap(buildAwsValue())
}
object GetInsightSummariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetInsightSummariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetInsightSummariesResponse =
      zio.aws.xray.model.GetInsightSummariesResponse(
        insightSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def insightSummaries
        : Optional[List[zio.aws.xray.model.InsightSummary.ReadOnly]]
    def nextToken: Optional[Token]
    def getInsightSummaries
        : ZIO[Any, AwsError, List[zio.aws.xray.model.InsightSummary.ReadOnly]] =
      AwsError.unwrapOptionField("insightSummaries", insightSummaries)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetInsightSummariesResponse
  ) extends zio.aws.xray.model.GetInsightSummariesResponse.ReadOnly {
    override val insightSummaries
        : Optional[List[zio.aws.xray.model.InsightSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insightSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.InsightSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.xray.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetInsightSummariesResponse
  ): zio.aws.xray.model.GetInsightSummariesResponse.ReadOnly = new Wrapper(impl)
}
