package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSamplingRulesRequest(
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest = {
    import GetSamplingRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetSamplingRulesRequest.ReadOnly =
    zio.aws.xray.model.GetSamplingRulesRequest.wrap(buildAwsValue())
}
object GetSamplingRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetSamplingRulesRequest =
      zio.aws.xray.model.GetSamplingRulesRequest(nextToken.map(value => value))
    def nextToken: Optional[String]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest
  ) extends zio.aws.xray.model.GetSamplingRulesRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest
  ): zio.aws.xray.model.GetSamplingRulesRequest.ReadOnly = new Wrapper(impl)
}
