package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSamplingStatisticSummariesResponse(
    samplingStatisticSummaries: Optional[
      Iterable[zio.aws.xray.model.SamplingStatisticSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse = {
    import GetSamplingStatisticSummariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse
      .builder()
      .optionallyWith(
        samplingStatisticSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.samplingStatisticSummaries)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.xray.model.GetSamplingStatisticSummariesResponse.ReadOnly =
    zio.aws.xray.model.GetSamplingStatisticSummariesResponse
      .wrap(buildAwsValue())
}
object GetSamplingStatisticSummariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetSamplingStatisticSummariesResponse =
      zio.aws.xray.model.GetSamplingStatisticSummariesResponse(
        samplingStatisticSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def samplingStatisticSummaries
        : Optional[List[zio.aws.xray.model.SamplingStatisticSummary.ReadOnly]]
    def nextToken: Optional[String]
    def getSamplingStatisticSummaries: ZIO[Any, AwsError, List[
      zio.aws.xray.model.SamplingStatisticSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "samplingStatisticSummaries",
      samplingStatisticSummaries
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse
  ) extends zio.aws.xray.model.GetSamplingStatisticSummariesResponse.ReadOnly {
    override val samplingStatisticSummaries
        : Optional[List[zio.aws.xray.model.SamplingStatisticSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.samplingStatisticSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.SamplingStatisticSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse
  ): zio.aws.xray.model.GetSamplingStatisticSummariesResponse.ReadOnly =
    new Wrapper(impl)
}
