package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSamplingTargetsRequest(
    samplingStatisticsDocuments: Iterable[
      zio.aws.xray.model.SamplingStatisticsDocument
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetSamplingTargetsRequest = {
    import GetSamplingTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetSamplingTargetsRequest
      .builder()
      .samplingStatisticsDocuments(samplingStatisticsDocuments.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetSamplingTargetsRequest.ReadOnly =
    zio.aws.xray.model.GetSamplingTargetsRequest.wrap(buildAwsValue())
}
object GetSamplingTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetSamplingTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetSamplingTargetsRequest =
      zio.aws.xray.model
        .GetSamplingTargetsRequest(samplingStatisticsDocuments.map { item =>
          item.asEditable
        })
    def samplingStatisticsDocuments
        : List[zio.aws.xray.model.SamplingStatisticsDocument.ReadOnly]
    def getSamplingStatisticsDocuments: ZIO[Any, Nothing, List[
      zio.aws.xray.model.SamplingStatisticsDocument.ReadOnly
    ]] = ZIO.succeed(samplingStatisticsDocuments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingTargetsRequest
  ) extends zio.aws.xray.model.GetSamplingTargetsRequest.ReadOnly {
    override val samplingStatisticsDocuments
        : List[zio.aws.xray.model.SamplingStatisticsDocument.ReadOnly] = impl
      .samplingStatisticsDocuments()
      .asScala
      .map { item =>
        zio.aws.xray.model.SamplingStatisticsDocument.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingTargetsRequest
  ): zio.aws.xray.model.GetSamplingTargetsRequest.ReadOnly = new Wrapper(impl)
}
