package zio.aws.xray.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetServiceGraphResponse(
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    services: Optional[Iterable[zio.aws.xray.model.Service]] = Optional.Absent,
    containsOldGroupVersions: Optional[Boolean] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetServiceGraphResponse = {
    import GetServiceGraphResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetServiceGraphResponse
      .builder()
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(
        containsOldGroupVersions.map(value => value: java.lang.Boolean)
      )(_.containsOldGroupVersions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetServiceGraphResponse.ReadOnly =
    zio.aws.xray.model.GetServiceGraphResponse.wrap(buildAwsValue())
}
object GetServiceGraphResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetServiceGraphResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetServiceGraphResponse =
      zio.aws.xray.model.GetServiceGraphResponse(
        startTime.map(value => value),
        endTime.map(value => value),
        services.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        containsOldGroupVersions.map(value => value),
        nextToken.map(value => value)
      )
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def services: Optional[List[zio.aws.xray.model.Service.ReadOnly]]
    def containsOldGroupVersions: Optional[Boolean]
    def nextToken: Optional[String]
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getServices
        : ZIO[Any, AwsError, List[zio.aws.xray.model.Service.ReadOnly]] =
      AwsError.unwrapOptionField("services", services)
    def getContainsOldGroupVersions: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("containsOldGroupVersions", containsOldGroupVersions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetServiceGraphResponse
  ) extends zio.aws.xray.model.GetServiceGraphResponse.ReadOnly {
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val services: Optional[List[zio.aws.xray.model.Service.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.services())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.Service.wrap(item)
          }.toList
        )
    override val containsOldGroupVersions: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containsOldGroupVersions())
        .map(value => value: Boolean)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetServiceGraphResponse
  ): zio.aws.xray.model.GetServiceGraphResponse.ReadOnly = new Wrapper(impl)
}
