package zio.aws.xray.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.{
  EntitySelectorExpression,
  Timestamp,
  GroupARN,
  GroupName,
  NullableBoolean,
  NullableInteger
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetTimeSeriesServiceStatisticsRequest(
    startTime: Timestamp,
    endTime: Timestamp,
    groupName: Optional[GroupName] = Optional.Absent,
    groupARN: Optional[GroupARN] = Optional.Absent,
    entitySelectorExpression: Optional[EntitySelectorExpression] =
      Optional.Absent,
    period: Optional[NullableInteger] = Optional.Absent,
    forecastStatistics: Optional[NullableBoolean] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest = {
    import GetTimeSeriesServiceStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupARN.map(value => GroupARN.unwrap(value): java.lang.String)
      )(_.groupARN)
      .optionallyWith(
        entitySelectorExpression.map(value =>
          EntitySelectorExpression.unwrap(value): java.lang.String
        )
      )(_.entitySelectorExpression)
      .optionallyWith(period.map(value => value: Integer))(_.period)
      .optionallyWith(
        forecastStatistics.map(value => value: java.lang.Boolean)
      )(_.forecastStatistics)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.xray.model.GetTimeSeriesServiceStatisticsRequest.ReadOnly =
    zio.aws.xray.model.GetTimeSeriesServiceStatisticsRequest
      .wrap(buildAwsValue())
}
object GetTimeSeriesServiceStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetTimeSeriesServiceStatisticsRequest =
      zio.aws.xray.model.GetTimeSeriesServiceStatisticsRequest(
        startTime,
        endTime,
        groupName.map(value => value),
        groupARN.map(value => value),
        entitySelectorExpression.map(value => value),
        period.map(value => value),
        forecastStatistics.map(value => value),
        nextToken.map(value => value)
      )
    def startTime: Timestamp
    def endTime: Timestamp
    def groupName: Optional[GroupName]
    def groupARN: Optional[GroupARN]
    def entitySelectorExpression: Optional[EntitySelectorExpression]
    def period: Optional[NullableInteger]
    def forecastStatistics: Optional[NullableBoolean]
    def nextToken: Optional[String]
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupARN: ZIO[Any, AwsError, GroupARN] =
      AwsError.unwrapOptionField("groupARN", groupARN)
    def getEntitySelectorExpression
        : ZIO[Any, AwsError, EntitySelectorExpression] = AwsError
      .unwrapOptionField("entitySelectorExpression", entitySelectorExpression)
    def getPeriod: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("period", period)
    def getForecastStatistics: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("forecastStatistics", forecastStatistics)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest
  ) extends zio.aws.xray.model.GetTimeSeriesServiceStatisticsRequest.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.endTime())
    override val groupName: Optional[GroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.xray.model.primitives.GroupName(value))
    override val groupARN: Optional[GroupARN] = zio.aws.core.internal
      .optionalFromNullable(impl.groupARN())
      .map(value => zio.aws.xray.model.primitives.GroupARN(value))
    override val entitySelectorExpression: Optional[EntitySelectorExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entitySelectorExpression())
        .map(value =>
          zio.aws.xray.model.primitives.EntitySelectorExpression(value)
        )
    override val period: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.period())
      .map(value => value: NullableInteger)
    override val forecastStatistics: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastStatistics())
        .map(value => value: NullableBoolean)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest
  ): zio.aws.xray.model.GetTimeSeriesServiceStatisticsRequest.ReadOnly =
    new Wrapper(impl)
}
