package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTraceGraphResponse(
    services: Optional[Iterable[zio.aws.xray.model.Service]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetTraceGraphResponse = {
    import GetTraceGraphResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetTraceGraphResponse
      .builder()
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetTraceGraphResponse.ReadOnly =
    zio.aws.xray.model.GetTraceGraphResponse.wrap(buildAwsValue())
}
object GetTraceGraphResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetTraceGraphResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetTraceGraphResponse =
      zio.aws.xray.model.GetTraceGraphResponse(
        services.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def services: Optional[List[zio.aws.xray.model.Service.ReadOnly]]
    def nextToken: Optional[String]
    def getServices
        : ZIO[Any, AwsError, List[zio.aws.xray.model.Service.ReadOnly]] =
      AwsError.unwrapOptionField("services", services)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetTraceGraphResponse
  ) extends zio.aws.xray.model.GetTraceGraphResponse.ReadOnly {
    override val services: Optional[List[zio.aws.xray.model.Service.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.services())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.Service.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetTraceGraphResponse
  ): zio.aws.xray.model.GetTraceGraphResponse.ReadOnly = new Wrapper(impl)
}
