package zio.aws.xray.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.{NullableLong, Timestamp}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetTraceSummariesResponse(
    traceSummaries: Optional[Iterable[zio.aws.xray.model.TraceSummary]] =
      Optional.Absent,
    approximateTime: Optional[Timestamp] = Optional.Absent,
    tracesProcessedCount: Optional[NullableLong] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse = {
    import GetTraceSummariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse
      .builder()
      .optionallyWith(
        traceSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.traceSummaries)
      .optionallyWith(
        approximateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.approximateTime)
      .optionallyWith(tracesProcessedCount.map(value => value: java.lang.Long))(
        _.tracesProcessedCount
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly =
    zio.aws.xray.model.GetTraceSummariesResponse.wrap(buildAwsValue())
}
object GetTraceSummariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetTraceSummariesResponse =
      zio.aws.xray.model.GetTraceSummariesResponse(
        traceSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        approximateTime.map(value => value),
        tracesProcessedCount.map(value => value),
        nextToken.map(value => value)
      )
    def traceSummaries: Optional[List[zio.aws.xray.model.TraceSummary.ReadOnly]]
    def approximateTime: Optional[Timestamp]
    def tracesProcessedCount: Optional[NullableLong]
    def nextToken: Optional[String]
    def getTraceSummaries
        : ZIO[Any, AwsError, List[zio.aws.xray.model.TraceSummary.ReadOnly]] =
      AwsError.unwrapOptionField("traceSummaries", traceSummaries)
    def getApproximateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("approximateTime", approximateTime)
    def getTracesProcessedCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("tracesProcessedCount", tracesProcessedCount)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse
  ) extends zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly {
    override val traceSummaries
        : Optional[List[zio.aws.xray.model.TraceSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.traceSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.TraceSummary.wrap(item)
          }.toList
        )
    override val approximateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.approximateTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val tracesProcessedCount: Optional[NullableLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tracesProcessedCount())
        .map(value => value: NullableLong)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse
  ): zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly = new Wrapper(impl)
}
