package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Group(
    groupName: Optional[String] = Optional.Absent,
    groupARN: Optional[String] = Optional.Absent,
    filterExpression: Optional[String] = Optional.Absent,
    insightsConfiguration: Optional[zio.aws.xray.model.InsightsConfiguration] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.xray.model.Group = {
    import Group.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.Group
      .builder()
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(groupARN.map(value => value: java.lang.String))(
        _.groupARN
      )
      .optionallyWith(filterExpression.map(value => value: java.lang.String))(
        _.filterExpression
      )
      .optionallyWith(
        insightsConfiguration.map(value => value.buildAwsValue())
      )(_.insightsConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.Group.ReadOnly =
    zio.aws.xray.model.Group.wrap(buildAwsValue())
}
object Group {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.Group] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.Group = zio.aws.xray.model.Group(
      groupName.map(value => value),
      groupARN.map(value => value),
      filterExpression.map(value => value),
      insightsConfiguration.map(value => value.asEditable)
    )
    def groupName: Optional[String]
    def groupARN: Optional[String]
    def filterExpression: Optional[String]
    def insightsConfiguration
        : Optional[zio.aws.xray.model.InsightsConfiguration.ReadOnly]
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupARN", groupARN)
    def getFilterExpression: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("filterExpression", filterExpression)
    def getInsightsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.xray.model.InsightsConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("insightsConfiguration", insightsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.Group
  ) extends zio.aws.xray.model.Group.ReadOnly {
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
    override val groupARN: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupARN())
      .map(value => value: String)
    override val filterExpression: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.filterExpression())
      .map(value => value: String)
    override val insightsConfiguration
        : Optional[zio.aws.xray.model.InsightsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insightsConfiguration())
        .map(value => zio.aws.xray.model.InsightsConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.Group
  ): zio.aws.xray.model.Group.ReadOnly = new Wrapper(impl)
}
