package zio.aws.xray.model
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.NullableInteger
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Http(
    httpURL: Optional[String] = Optional.Absent,
    httpStatus: Optional[NullableInteger] = Optional.Absent,
    httpMethod: Optional[String] = Optional.Absent,
    userAgent: Optional[String] = Optional.Absent,
    clientIp: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.xray.model.Http = {
    import Http.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.Http
      .builder()
      .optionallyWith(httpURL.map(value => value: java.lang.String))(_.httpURL)
      .optionallyWith(httpStatus.map(value => value: Integer))(_.httpStatus)
      .optionallyWith(httpMethod.map(value => value: java.lang.String))(
        _.httpMethod
      )
      .optionallyWith(userAgent.map(value => value: java.lang.String))(
        _.userAgent
      )
      .optionallyWith(clientIp.map(value => value: java.lang.String))(
        _.clientIp
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.Http.ReadOnly =
    zio.aws.xray.model.Http.wrap(buildAwsValue())
}
object Http {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.Http] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.Http = zio.aws.xray.model.Http(
      httpURL.map(value => value),
      httpStatus.map(value => value),
      httpMethod.map(value => value),
      userAgent.map(value => value),
      clientIp.map(value => value)
    )
    def httpURL: Optional[String]
    def httpStatus: Optional[NullableInteger]
    def httpMethod: Optional[String]
    def userAgent: Optional[String]
    def clientIp: Optional[String]
    def getHttpURL: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("httpURL", httpURL)
    def getHttpStatus: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("httpStatus", httpStatus)
    def getHttpMethod: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getUserAgent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userAgent", userAgent)
    def getClientIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientIp", clientIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.Http
  ) extends zio.aws.xray.model.Http.ReadOnly {
    override val httpURL: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.httpURL())
      .map(value => value: String)
    override val httpStatus: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.httpStatus())
      .map(value => value: NullableInteger)
    override val httpMethod: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.httpMethod())
      .map(value => value: String)
    override val userAgent: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userAgent())
      .map(value => value: String)
    override val clientIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientIp())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.Http
  ): zio.aws.xray.model.Http.ReadOnly = new Wrapper(impl)
}
