package zio.aws.xray.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.{
  Timestamp,
  GroupARN,
  InsightSummaryText,
  InsightId,
  GroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Insight(
    insightId: Optional[InsightId] = Optional.Absent,
    groupARN: Optional[GroupARN] = Optional.Absent,
    groupName: Optional[GroupName] = Optional.Absent,
    rootCauseServiceId: Optional[zio.aws.xray.model.ServiceId] =
      Optional.Absent,
    categories: Optional[Iterable[zio.aws.xray.model.InsightCategory]] =
      Optional.Absent,
    state: Optional[zio.aws.xray.model.InsightState] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    summary: Optional[InsightSummaryText] = Optional.Absent,
    clientRequestImpactStatistics: Optional[
      zio.aws.xray.model.RequestImpactStatistics
    ] = Optional.Absent,
    rootCauseServiceRequestImpactStatistics: Optional[
      zio.aws.xray.model.RequestImpactStatistics
    ] = Optional.Absent,
    topAnomalousServices: Optional[
      Iterable[zio.aws.xray.model.AnomalousService]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.xray.model.Insight = {
    import Insight.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.Insight
      .builder()
      .optionallyWith(
        insightId.map(value => InsightId.unwrap(value): java.lang.String)
      )(_.insightId)
      .optionallyWith(
        groupARN.map(value => GroupARN.unwrap(value): java.lang.String)
      )(_.groupARN)
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(rootCauseServiceId.map(value => value.buildAwsValue()))(
        _.rootCauseServiceId
      )
      .optionallyWith(
        categories.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.categoriesWithStrings)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        summary.map(value => InsightSummaryText.unwrap(value): java.lang.String)
      )(_.summary)
      .optionallyWith(
        clientRequestImpactStatistics.map(value => value.buildAwsValue())
      )(_.clientRequestImpactStatistics)
      .optionallyWith(
        rootCauseServiceRequestImpactStatistics.map(value =>
          value.buildAwsValue()
        )
      )(_.rootCauseServiceRequestImpactStatistics)
      .optionallyWith(
        topAnomalousServices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topAnomalousServices)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.Insight.ReadOnly =
    zio.aws.xray.model.Insight.wrap(buildAwsValue())
}
object Insight {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.Insight] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.Insight = zio.aws.xray.model.Insight(
      insightId.map(value => value),
      groupARN.map(value => value),
      groupName.map(value => value),
      rootCauseServiceId.map(value => value.asEditable),
      categories.map(value => value),
      state.map(value => value),
      startTime.map(value => value),
      endTime.map(value => value),
      summary.map(value => value),
      clientRequestImpactStatistics.map(value => value.asEditable),
      rootCauseServiceRequestImpactStatistics.map(value => value.asEditable),
      topAnomalousServices.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def insightId: Optional[InsightId]
    def groupARN: Optional[GroupARN]
    def groupName: Optional[GroupName]
    def rootCauseServiceId: Optional[zio.aws.xray.model.ServiceId.ReadOnly]
    def categories: Optional[List[zio.aws.xray.model.InsightCategory]]
    def state: Optional[zio.aws.xray.model.InsightState]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def summary: Optional[InsightSummaryText]
    def clientRequestImpactStatistics
        : Optional[zio.aws.xray.model.RequestImpactStatistics.ReadOnly]
    def rootCauseServiceRequestImpactStatistics
        : Optional[zio.aws.xray.model.RequestImpactStatistics.ReadOnly]
    def topAnomalousServices
        : Optional[List[zio.aws.xray.model.AnomalousService.ReadOnly]]
    def getInsightId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("insightId", insightId)
    def getGroupARN: ZIO[Any, AwsError, GroupARN] =
      AwsError.unwrapOptionField("groupARN", groupARN)
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getRootCauseServiceId
        : ZIO[Any, AwsError, zio.aws.xray.model.ServiceId.ReadOnly] =
      AwsError.unwrapOptionField("rootCauseServiceId", rootCauseServiceId)
    def getCategories
        : ZIO[Any, AwsError, List[zio.aws.xray.model.InsightCategory]] =
      AwsError.unwrapOptionField("categories", categories)
    def getState: ZIO[Any, AwsError, zio.aws.xray.model.InsightState] =
      AwsError.unwrapOptionField("state", state)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getSummary: ZIO[Any, AwsError, InsightSummaryText] =
      AwsError.unwrapOptionField("summary", summary)
    def getClientRequestImpactStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.xray.model.RequestImpactStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clientRequestImpactStatistics",
      clientRequestImpactStatistics
    )
    def getRootCauseServiceRequestImpactStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.xray.model.RequestImpactStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rootCauseServiceRequestImpactStatistics",
      rootCauseServiceRequestImpactStatistics
    )
    def getTopAnomalousServices: ZIO[Any, AwsError, List[
      zio.aws.xray.model.AnomalousService.ReadOnly
    ]] =
      AwsError.unwrapOptionField("topAnomalousServices", topAnomalousServices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.Insight
  ) extends zio.aws.xray.model.Insight.ReadOnly {
    override val insightId: Optional[InsightId] = zio.aws.core.internal
      .optionalFromNullable(impl.insightId())
      .map(value => zio.aws.xray.model.primitives.InsightId(value))
    override val groupARN: Optional[GroupARN] = zio.aws.core.internal
      .optionalFromNullable(impl.groupARN())
      .map(value => zio.aws.xray.model.primitives.GroupARN(value))
    override val groupName: Optional[GroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.xray.model.primitives.GroupName(value))
    override val rootCauseServiceId
        : Optional[zio.aws.xray.model.ServiceId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootCauseServiceId())
        .map(value => zio.aws.xray.model.ServiceId.wrap(value))
    override val categories
        : Optional[List[zio.aws.xray.model.InsightCategory]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.categories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.InsightCategory.wrap(item)
          }.toList
        )
    override val state: Optional[zio.aws.xray.model.InsightState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.xray.model.InsightState.wrap(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val summary: Optional[InsightSummaryText] = zio.aws.core.internal
      .optionalFromNullable(impl.summary())
      .map(value => zio.aws.xray.model.primitives.InsightSummaryText(value))
    override val clientRequestImpactStatistics
        : Optional[zio.aws.xray.model.RequestImpactStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestImpactStatistics())
        .map(value => zio.aws.xray.model.RequestImpactStatistics.wrap(value))
    override val rootCauseServiceRequestImpactStatistics
        : Optional[zio.aws.xray.model.RequestImpactStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootCauseServiceRequestImpactStatistics())
        .map(value => zio.aws.xray.model.RequestImpactStatistics.wrap(value))
    override val topAnomalousServices
        : Optional[List[zio.aws.xray.model.AnomalousService.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topAnomalousServices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.AnomalousService.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.Insight
  ): zio.aws.xray.model.Insight.ReadOnly = new Wrapper(impl)
}
