package zio.aws.xray.model
import scala.jdk.CollectionConverters._
sealed trait InsightCategory {
  def unwrap: software.amazon.awssdk.services.xray.model.InsightCategory
}
object InsightCategory {
  def wrap(
      value: software.amazon.awssdk.services.xray.model.InsightCategory
  ): zio.aws.xray.model.InsightCategory = value match {
    case software.amazon.awssdk.services.xray.model.InsightCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.xray.model.InsightCategory.FAULT =>
      val r = FAULT
      r
  }
  case object unknownToSdkVersion extends zio.aws.xray.model.InsightCategory {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.InsightCategory =
      software.amazon.awssdk.services.xray.model.InsightCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object FAULT extends zio.aws.xray.model.InsightCategory {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.InsightCategory =
      software.amazon.awssdk.services.xray.model.InsightCategory.FAULT
  }
}
