package zio.aws.xray.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.{Timestamp, EventSummaryText}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class InsightEvent(
    summary: Optional[EventSummaryText] = Optional.Absent,
    eventTime: Optional[Timestamp] = Optional.Absent,
    clientRequestImpactStatistics: Optional[
      zio.aws.xray.model.RequestImpactStatistics
    ] = Optional.Absent,
    rootCauseServiceRequestImpactStatistics: Optional[
      zio.aws.xray.model.RequestImpactStatistics
    ] = Optional.Absent,
    topAnomalousServices: Optional[
      Iterable[zio.aws.xray.model.AnomalousService]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.InsightEvent = {
    import InsightEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.InsightEvent
      .builder()
      .optionallyWith(
        summary.map(value => EventSummaryText.unwrap(value): java.lang.String)
      )(_.summary)
      .optionallyWith(eventTime.map(value => Timestamp.unwrap(value): Instant))(
        _.eventTime
      )
      .optionallyWith(
        clientRequestImpactStatistics.map(value => value.buildAwsValue())
      )(_.clientRequestImpactStatistics)
      .optionallyWith(
        rootCauseServiceRequestImpactStatistics.map(value =>
          value.buildAwsValue()
        )
      )(_.rootCauseServiceRequestImpactStatistics)
      .optionallyWith(
        topAnomalousServices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topAnomalousServices)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.InsightEvent.ReadOnly =
    zio.aws.xray.model.InsightEvent.wrap(buildAwsValue())
}
object InsightEvent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.InsightEvent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.InsightEvent =
      zio.aws.xray.model.InsightEvent(
        summary.map(value => value),
        eventTime.map(value => value),
        clientRequestImpactStatistics.map(value => value.asEditable),
        rootCauseServiceRequestImpactStatistics.map(value => value.asEditable),
        topAnomalousServices.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def summary: Optional[EventSummaryText]
    def eventTime: Optional[Timestamp]
    def clientRequestImpactStatistics
        : Optional[zio.aws.xray.model.RequestImpactStatistics.ReadOnly]
    def rootCauseServiceRequestImpactStatistics
        : Optional[zio.aws.xray.model.RequestImpactStatistics.ReadOnly]
    def topAnomalousServices
        : Optional[List[zio.aws.xray.model.AnomalousService.ReadOnly]]
    def getSummary: ZIO[Any, AwsError, EventSummaryText] =
      AwsError.unwrapOptionField("summary", summary)
    def getEventTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventTime", eventTime)
    def getClientRequestImpactStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.xray.model.RequestImpactStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clientRequestImpactStatistics",
      clientRequestImpactStatistics
    )
    def getRootCauseServiceRequestImpactStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.xray.model.RequestImpactStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rootCauseServiceRequestImpactStatistics",
      rootCauseServiceRequestImpactStatistics
    )
    def getTopAnomalousServices: ZIO[Any, AwsError, List[
      zio.aws.xray.model.AnomalousService.ReadOnly
    ]] =
      AwsError.unwrapOptionField("topAnomalousServices", topAnomalousServices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.InsightEvent
  ) extends zio.aws.xray.model.InsightEvent.ReadOnly {
    override val summary: Optional[EventSummaryText] = zio.aws.core.internal
      .optionalFromNullable(impl.summary())
      .map(value => zio.aws.xray.model.primitives.EventSummaryText(value))
    override val eventTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val clientRequestImpactStatistics
        : Optional[zio.aws.xray.model.RequestImpactStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestImpactStatistics())
        .map(value => zio.aws.xray.model.RequestImpactStatistics.wrap(value))
    override val rootCauseServiceRequestImpactStatistics
        : Optional[zio.aws.xray.model.RequestImpactStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootCauseServiceRequestImpactStatistics())
        .map(value => zio.aws.xray.model.RequestImpactStatistics.wrap(value))
    override val topAnomalousServices
        : Optional[List[zio.aws.xray.model.AnomalousService.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topAnomalousServices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.AnomalousService.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.InsightEvent
  ): zio.aws.xray.model.InsightEvent.ReadOnly = new Wrapper(impl)
}
