package zio.aws.xray.model
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.NullableInteger
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InsightImpactGraphService(
    referenceId: Optional[NullableInteger] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    names: Optional[Iterable[String]] = Optional.Absent,
    accountId: Optional[String] = Optional.Absent,
    edges: Optional[Iterable[zio.aws.xray.model.InsightImpactGraphEdge]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.InsightImpactGraphService = {
    import InsightImpactGraphService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.InsightImpactGraphService
      .builder()
      .optionallyWith(referenceId.map(value => value: Integer))(_.referenceId)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(
        edges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.edges)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.InsightImpactGraphService.ReadOnly =
    zio.aws.xray.model.InsightImpactGraphService.wrap(buildAwsValue())
}
object InsightImpactGraphService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.InsightImpactGraphService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.InsightImpactGraphService =
      zio.aws.xray.model.InsightImpactGraphService(
        referenceId.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        names.map(value => value),
        accountId.map(value => value),
        edges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def referenceId: Optional[NullableInteger]
    def `type`: Optional[String]
    def name: Optional[String]
    def names: Optional[List[String]]
    def accountId: Optional[String]
    def edges
        : Optional[List[zio.aws.xray.model.InsightImpactGraphEdge.ReadOnly]]
    def getReferenceId: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("referenceId", referenceId)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("names", names)
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getEdges: ZIO[Any, AwsError, List[
      zio.aws.xray.model.InsightImpactGraphEdge.ReadOnly
    ]] = AwsError.unwrapOptionField("edges", edges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.InsightImpactGraphService
  ) extends zio.aws.xray.model.InsightImpactGraphService.ReadOnly {
    override val referenceId: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceId())
      .map(value => value: NullableInteger)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val names: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val accountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: String)
    override val edges
        : Optional[List[zio.aws.xray.model.InsightImpactGraphEdge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.InsightImpactGraphEdge.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.InsightImpactGraphService
  ): zio.aws.xray.model.InsightImpactGraphService.ReadOnly = new Wrapper(impl)
}
