package zio.aws.xray.model
import scala.jdk.CollectionConverters._
sealed trait InsightState {
  def unwrap: software.amazon.awssdk.services.xray.model.InsightState
}
object InsightState {
  def wrap(
      value: software.amazon.awssdk.services.xray.model.InsightState
  ): zio.aws.xray.model.InsightState = value match {
    case software.amazon.awssdk.services.xray.model.InsightState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.xray.model.InsightState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.xray.model.InsightState.CLOSED =>
      val r = CLOSED
      r
  }
  case object unknownToSdkVersion extends zio.aws.xray.model.InsightState {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.InsightState =
      software.amazon.awssdk.services.xray.model.InsightState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.xray.model.InsightState {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.InsightState =
      software.amazon.awssdk.services.xray.model.InsightState.ACTIVE
  }
  case object CLOSED extends zio.aws.xray.model.InsightState {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.InsightState =
      software.amazon.awssdk.services.xray.model.InsightState.CLOSED
  }
}
