package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutEncryptionConfigResponse(
    encryptionConfig: Optional[zio.aws.xray.model.EncryptionConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.PutEncryptionConfigResponse = {
    import PutEncryptionConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.PutEncryptionConfigResponse
      .builder()
      .optionallyWith(encryptionConfig.map(value => value.buildAwsValue()))(
        _.encryptionConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.PutEncryptionConfigResponse.ReadOnly =
    zio.aws.xray.model.PutEncryptionConfigResponse.wrap(buildAwsValue())
}
object PutEncryptionConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.PutEncryptionConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.PutEncryptionConfigResponse =
      zio.aws.xray.model.PutEncryptionConfigResponse(
        encryptionConfig.map(value => value.asEditable)
      )
    def encryptionConfig: Optional[zio.aws.xray.model.EncryptionConfig.ReadOnly]
    def getEncryptionConfig
        : ZIO[Any, AwsError, zio.aws.xray.model.EncryptionConfig.ReadOnly] =
      AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.PutEncryptionConfigResponse
  ) extends zio.aws.xray.model.PutEncryptionConfigResponse.ReadOnly {
    override val encryptionConfig
        : Optional[zio.aws.xray.model.EncryptionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfig())
        .map(value => zio.aws.xray.model.EncryptionConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.PutEncryptionConfigResponse
  ): zio.aws.xray.model.PutEncryptionConfigResponse.ReadOnly = new Wrapper(impl)
}
