package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableLong
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RequestImpactStatistics(
    faultCount: Optional[NullableLong] = Optional.Absent,
    okCount: Optional[NullableLong] = Optional.Absent,
    totalCount: Optional[NullableLong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.RequestImpactStatistics = {
    import RequestImpactStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.RequestImpactStatistics
      .builder()
      .optionallyWith(faultCount.map(value => value: java.lang.Long))(
        _.faultCount
      )
      .optionallyWith(okCount.map(value => value: java.lang.Long))(_.okCount)
      .optionallyWith(totalCount.map(value => value: java.lang.Long))(
        _.totalCount
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.RequestImpactStatistics.ReadOnly =
    zio.aws.xray.model.RequestImpactStatistics.wrap(buildAwsValue())
}
object RequestImpactStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.RequestImpactStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.RequestImpactStatistics =
      zio.aws.xray.model.RequestImpactStatistics(
        faultCount.map(value => value),
        okCount.map(value => value),
        totalCount.map(value => value)
      )
    def faultCount: Optional[NullableLong]
    def okCount: Optional[NullableLong]
    def totalCount: Optional[NullableLong]
    def getFaultCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("faultCount", faultCount)
    def getOkCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("okCount", okCount)
    def getTotalCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.RequestImpactStatistics
  ) extends zio.aws.xray.model.RequestImpactStatistics.ReadOnly {
    override val faultCount: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.faultCount())
      .map(value => value: NullableLong)
    override val okCount: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.okCount())
      .map(value => value: NullableLong)
    override val totalCount: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => value: NullableLong)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.RequestImpactStatistics
  ): zio.aws.xray.model.RequestImpactStatistics.ReadOnly = new Wrapper(impl)
}
