package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceARNDetail(arn: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.ResourceARNDetail = {
    import ResourceARNDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.ResourceARNDetail
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.ResourceARNDetail.ReadOnly =
    zio.aws.xray.model.ResourceARNDetail.wrap(buildAwsValue())
}
object ResourceARNDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.ResourceARNDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.ResourceARNDetail =
      zio.aws.xray.model.ResourceARNDetail(arn.map(value => value))
    def arn: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.ResourceARNDetail
  ) extends zio.aws.xray.model.ResourceARNDetail.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.ResourceARNDetail
  ): zio.aws.xray.model.ResourceARNDetail.ReadOnly = new Wrapper(impl)
}
