package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableBoolean
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResponseTimeRootCause(
    services: Optional[
      Iterable[zio.aws.xray.model.ResponseTimeRootCauseService]
    ] = Optional.Absent,
    clientImpacting: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.ResponseTimeRootCause = {
    import ResponseTimeRootCause.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.ResponseTimeRootCause
      .builder()
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(clientImpacting.map(value => value: java.lang.Boolean))(
        _.clientImpacting
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.ResponseTimeRootCause.ReadOnly =
    zio.aws.xray.model.ResponseTimeRootCause.wrap(buildAwsValue())
}
object ResponseTimeRootCause {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.ResponseTimeRootCause
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.ResponseTimeRootCause =
      zio.aws.xray.model.ResponseTimeRootCause(
        services.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientImpacting.map(value => value)
      )
    def services: Optional[
      List[zio.aws.xray.model.ResponseTimeRootCauseService.ReadOnly]
    ]
    def clientImpacting: Optional[NullableBoolean]
    def getServices: ZIO[Any, AwsError, List[
      zio.aws.xray.model.ResponseTimeRootCauseService.ReadOnly
    ]] = AwsError.unwrapOptionField("services", services)
    def getClientImpacting: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("clientImpacting", clientImpacting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.ResponseTimeRootCause
  ) extends zio.aws.xray.model.ResponseTimeRootCause.ReadOnly {
    override val services: Optional[
      List[zio.aws.xray.model.ResponseTimeRootCauseService.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.services())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.ResponseTimeRootCauseService.wrap(item)
        }.toList
      )
    override val clientImpacting: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientImpacting())
        .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.ResponseTimeRootCause
  ): zio.aws.xray.model.ResponseTimeRootCause.ReadOnly = new Wrapper(impl)
}
