package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{NullableBoolean, NullableDouble}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResponseTimeRootCauseEntity(
    name: Optional[String] = Optional.Absent,
    coverage: Optional[NullableDouble] = Optional.Absent,
    remote: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.ResponseTimeRootCauseEntity = {
    import ResponseTimeRootCauseEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.ResponseTimeRootCauseEntity
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(coverage.map(value => value: java.lang.Double))(
        _.coverage
      )
      .optionallyWith(remote.map(value => value: java.lang.Boolean))(_.remote)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.ResponseTimeRootCauseEntity.ReadOnly =
    zio.aws.xray.model.ResponseTimeRootCauseEntity.wrap(buildAwsValue())
}
object ResponseTimeRootCauseEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.ResponseTimeRootCauseEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.ResponseTimeRootCauseEntity =
      zio.aws.xray.model.ResponseTimeRootCauseEntity(
        name.map(value => value),
        coverage.map(value => value),
        remote.map(value => value)
      )
    def name: Optional[String]
    def coverage: Optional[NullableDouble]
    def remote: Optional[NullableBoolean]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getCoverage: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("coverage", coverage)
    def getRemote: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("remote", remote)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.ResponseTimeRootCauseEntity
  ) extends zio.aws.xray.model.ResponseTimeRootCauseEntity.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val coverage: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.coverage())
      .map(value => value: NullableDouble)
    override val remote: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.remote())
      .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.ResponseTimeRootCauseEntity
  ): zio.aws.xray.model.ResponseTimeRootCauseEntity.ReadOnly = new Wrapper(impl)
}
