package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableBoolean
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResponseTimeRootCauseService(
    name: Optional[String] = Optional.Absent,
    names: Optional[Iterable[String]] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    accountId: Optional[String] = Optional.Absent,
    entityPath: Optional[
      Iterable[zio.aws.xray.model.ResponseTimeRootCauseEntity]
    ] = Optional.Absent,
    inferred: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.ResponseTimeRootCauseService = {
    import ResponseTimeRootCauseService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.ResponseTimeRootCauseService
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(
        entityPath.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entityPath)
      .optionallyWith(inferred.map(value => value: java.lang.Boolean))(
        _.inferred
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.ResponseTimeRootCauseService.ReadOnly =
    zio.aws.xray.model.ResponseTimeRootCauseService.wrap(buildAwsValue())
}
object ResponseTimeRootCauseService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.ResponseTimeRootCauseService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.ResponseTimeRootCauseService =
      zio.aws.xray.model.ResponseTimeRootCauseService(
        name.map(value => value),
        names.map(value => value),
        `type`.map(value => value),
        accountId.map(value => value),
        entityPath.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inferred.map(value => value)
      )
    def name: Optional[String]
    def names: Optional[List[String]]
    def `type`: Optional[String]
    def accountId: Optional[String]
    def entityPath: Optional[
      List[zio.aws.xray.model.ResponseTimeRootCauseEntity.ReadOnly]
    ]
    def inferred: Optional[NullableBoolean]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("names", names)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getEntityPath: ZIO[Any, AwsError, List[
      zio.aws.xray.model.ResponseTimeRootCauseEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("entityPath", entityPath)
    def getInferred: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("inferred", inferred)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.ResponseTimeRootCauseService
  ) extends zio.aws.xray.model.ResponseTimeRootCauseService.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val names: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val accountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: String)
    override val entityPath: Optional[
      List[zio.aws.xray.model.ResponseTimeRootCauseEntity.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entityPath())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.ResponseTimeRootCauseEntity.wrap(item)
        }.toList
      )
    override val inferred: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.inferred())
      .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.ResponseTimeRootCauseService
  ): zio.aws.xray.model.ResponseTimeRootCauseService.ReadOnly = new Wrapper(
    impl
  )
}
