package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RootCauseException(
    name: Optional[String] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.RootCauseException = {
    import RootCauseException.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.RootCauseException
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.RootCauseException.ReadOnly =
    zio.aws.xray.model.RootCauseException.wrap(buildAwsValue())
}
object RootCauseException {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.RootCauseException
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.RootCauseException = zio.aws.xray.model
      .RootCauseException(name.map(value => value), message.map(value => value))
    def name: Optional[String]
    def message: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.RootCauseException
  ) extends zio.aws.xray.model.RootCauseException.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.RootCauseException
  ): zio.aws.xray.model.RootCauseException.ReadOnly = new Wrapper(impl)
}
