package zio.aws.xray.model
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.{
  Host,
  ServiceType,
  NullableDouble,
  HTTPMethod,
  RuleName,
  ResourceARN,
  AttributeKey,
  ServiceName,
  NullableInteger,
  AttributeValue,
  URLPath
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SamplingRuleUpdate(
    ruleName: Optional[RuleName] = Optional.Absent,
    ruleARN: Optional[String] = Optional.Absent,
    resourceARN: Optional[ResourceARN] = Optional.Absent,
    priority: Optional[NullableInteger] = Optional.Absent,
    fixedRate: Optional[NullableDouble] = Optional.Absent,
    reservoirSize: Optional[NullableInteger] = Optional.Absent,
    host: Optional[Host] = Optional.Absent,
    serviceName: Optional[ServiceName] = Optional.Absent,
    serviceType: Optional[ServiceType] = Optional.Absent,
    httpMethod: Optional[HTTPMethod] = Optional.Absent,
    urlPath: Optional[URLPath] = Optional.Absent,
    attributes: Optional[Map[AttributeKey, AttributeValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.SamplingRuleUpdate = {
    import SamplingRuleUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.SamplingRuleUpdate
      .builder()
      .optionallyWith(
        ruleName.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(ruleARN.map(value => value: java.lang.String))(_.ruleARN)
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(priority.map(value => value: Integer))(_.priority)
      .optionallyWith(fixedRate.map(value => value: java.lang.Double))(
        _.fixedRate
      )
      .optionallyWith(reservoirSize.map(value => value: Integer))(
        _.reservoirSize
      )
      .optionallyWith(host.map(value => Host.unwrap(value): java.lang.String))(
        _.host
      )
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        serviceType.map(value => ServiceType.unwrap(value): java.lang.String)
      )(_.serviceType)
      .optionallyWith(
        httpMethod.map(value => HTTPMethod.unwrap(value): java.lang.String)
      )(_.httpMethod)
      .optionallyWith(
        urlPath.map(value => URLPath.unwrap(value): java.lang.String)
      )(_.urlPath)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeKey.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.SamplingRuleUpdate.ReadOnly =
    zio.aws.xray.model.SamplingRuleUpdate.wrap(buildAwsValue())
}
object SamplingRuleUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.SamplingRuleUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.SamplingRuleUpdate =
      zio.aws.xray.model.SamplingRuleUpdate(
        ruleName.map(value => value),
        ruleARN.map(value => value),
        resourceARN.map(value => value),
        priority.map(value => value),
        fixedRate.map(value => value),
        reservoirSize.map(value => value),
        host.map(value => value),
        serviceName.map(value => value),
        serviceType.map(value => value),
        httpMethod.map(value => value),
        urlPath.map(value => value),
        attributes.map(value => value)
      )
    def ruleName: Optional[RuleName]
    def ruleARN: Optional[String]
    def resourceARN: Optional[ResourceARN]
    def priority: Optional[NullableInteger]
    def fixedRate: Optional[NullableDouble]
    def reservoirSize: Optional[NullableInteger]
    def host: Optional[Host]
    def serviceName: Optional[ServiceName]
    def serviceType: Optional[ServiceType]
    def httpMethod: Optional[HTTPMethod]
    def urlPath: Optional[URLPath]
    def attributes: Optional[Map[AttributeKey, AttributeValue]]
    def getRuleName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getRuleARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleARN", ruleARN)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getPriority: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("priority", priority)
    def getFixedRate: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("fixedRate", fixedRate)
    def getReservoirSize: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("reservoirSize", reservoirSize)
    def getHost: ZIO[Any, AwsError, Host] =
      AwsError.unwrapOptionField("host", host)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceType: ZIO[Any, AwsError, ServiceType] =
      AwsError.unwrapOptionField("serviceType", serviceType)
    def getHttpMethod: ZIO[Any, AwsError, HTTPMethod] =
      AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getUrlPath: ZIO[Any, AwsError, URLPath] =
      AwsError.unwrapOptionField("urlPath", urlPath)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeKey, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.SamplingRuleUpdate
  ) extends zio.aws.xray.model.SamplingRuleUpdate.ReadOnly {
    override val ruleName: Optional[RuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleName())
      .map(value => zio.aws.xray.model.primitives.RuleName(value))
    override val ruleARN: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleARN())
      .map(value => value: String)
    override val resourceARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value => zio.aws.xray.model.primitives.ResourceARN(value))
    override val priority: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: NullableInteger)
    override val fixedRate: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedRate())
      .map(value => value: NullableDouble)
    override val reservoirSize: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservoirSize())
        .map(value => value: NullableInteger)
    override val host: Optional[Host] = zio.aws.core.internal
      .optionalFromNullable(impl.host())
      .map(value => zio.aws.xray.model.primitives.Host(value))
    override val serviceName: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.xray.model.primitives.ServiceName(value))
    override val serviceType: Optional[ServiceType] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceType())
      .map(value => zio.aws.xray.model.primitives.ServiceType(value))
    override val httpMethod: Optional[HTTPMethod] = zio.aws.core.internal
      .optionalFromNullable(impl.httpMethod())
      .map(value => zio.aws.xray.model.primitives.HTTPMethod(value))
    override val urlPath: Optional[URLPath] = zio.aws.core.internal
      .optionalFromNullable(impl.urlPath())
      .map(value => zio.aws.xray.model.primitives.URLPath(value))
    override val attributes: Optional[Map[AttributeKey, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.xray.model.primitives.AttributeKey(
                key
              ) -> zio.aws.xray.model.primitives.AttributeValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.SamplingRuleUpdate
  ): zio.aws.xray.model.SamplingRuleUpdate.ReadOnly = new Wrapper(impl)
}
