package zio.aws.xray.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.{Integer, Timestamp}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SamplingStatisticSummary(
    ruleName: Optional[String] = Optional.Absent,
    timestamp: Optional[Timestamp] = Optional.Absent,
    requestCount: Optional[Integer] = Optional.Absent,
    borrowCount: Optional[Integer] = Optional.Absent,
    sampledCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.SamplingStatisticSummary = {
    import SamplingStatisticSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.SamplingStatisticSummary
      .builder()
      .optionallyWith(ruleName.map(value => value: java.lang.String))(
        _.ruleName
      )
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(requestCount.map(value => value: java.lang.Integer))(
        _.requestCount
      )
      .optionallyWith(borrowCount.map(value => value: java.lang.Integer))(
        _.borrowCount
      )
      .optionallyWith(sampledCount.map(value => value: java.lang.Integer))(
        _.sampledCount
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.SamplingStatisticSummary.ReadOnly =
    zio.aws.xray.model.SamplingStatisticSummary.wrap(buildAwsValue())
}
object SamplingStatisticSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.SamplingStatisticSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.SamplingStatisticSummary =
      zio.aws.xray.model.SamplingStatisticSummary(
        ruleName.map(value => value),
        timestamp.map(value => value),
        requestCount.map(value => value),
        borrowCount.map(value => value),
        sampledCount.map(value => value)
      )
    def ruleName: Optional[String]
    def timestamp: Optional[Timestamp]
    def requestCount: Optional[Integer]
    def borrowCount: Optional[Integer]
    def sampledCount: Optional[Integer]
    def getRuleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getRequestCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("requestCount", requestCount)
    def getBorrowCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("borrowCount", borrowCount)
    def getSampledCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sampledCount", sampledCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.SamplingStatisticSummary
  ) extends zio.aws.xray.model.SamplingStatisticSummary.ReadOnly {
    override val ruleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleName())
      .map(value => value: String)
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val requestCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.requestCount())
      .map(value => value: Integer)
    override val borrowCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.borrowCount())
      .map(value => value: Integer)
    override val sampledCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sampledCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.SamplingStatisticSummary
  ): zio.aws.xray.model.SamplingStatisticSummary.ReadOnly = new Wrapper(impl)
}
