package zio.aws.xray.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.{
  ClientID,
  RequestCount,
  Timestamp,
  BorrowCount,
  SampledCount,
  RuleName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SamplingStatisticsDocument(
    ruleName: RuleName,
    clientID: ClientID,
    timestamp: Timestamp,
    requestCount: RequestCount,
    sampledCount: SampledCount,
    borrowCount: Optional[BorrowCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.SamplingStatisticsDocument = {
    import SamplingStatisticsDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.SamplingStatisticsDocument
      .builder()
      .ruleName(RuleName.unwrap(ruleName): java.lang.String)
      .clientID(ClientID.unwrap(clientID): java.lang.String)
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .requestCount(RequestCount.unwrap(requestCount): Integer)
      .sampledCount(SampledCount.unwrap(sampledCount): Integer)
      .optionallyWith(
        borrowCount.map(value => BorrowCount.unwrap(value): Integer)
      )(_.borrowCount)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.SamplingStatisticsDocument.ReadOnly =
    zio.aws.xray.model.SamplingStatisticsDocument.wrap(buildAwsValue())
}
object SamplingStatisticsDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.SamplingStatisticsDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.SamplingStatisticsDocument =
      zio.aws.xray.model.SamplingStatisticsDocument(
        ruleName,
        clientID,
        timestamp,
        requestCount,
        sampledCount,
        borrowCount.map(value => value)
      )
    def ruleName: RuleName
    def clientID: ClientID
    def timestamp: Timestamp
    def requestCount: RequestCount
    def sampledCount: SampledCount
    def borrowCount: Optional[BorrowCount]
    def getRuleName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(ruleName)
    def getClientID: ZIO[Any, Nothing, ClientID] = ZIO.succeed(clientID)
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getRequestCount: ZIO[Any, Nothing, RequestCount] =
      ZIO.succeed(requestCount)
    def getSampledCount: ZIO[Any, Nothing, SampledCount] =
      ZIO.succeed(sampledCount)
    def getBorrowCount: ZIO[Any, AwsError, BorrowCount] =
      AwsError.unwrapOptionField("borrowCount", borrowCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.SamplingStatisticsDocument
  ) extends zio.aws.xray.model.SamplingStatisticsDocument.ReadOnly {
    override val ruleName: RuleName =
      zio.aws.xray.model.primitives.RuleName(impl.ruleName())
    override val clientID: ClientID =
      zio.aws.xray.model.primitives.ClientID(impl.clientID())
    override val timestamp: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.timestamp())
    override val requestCount: RequestCount =
      zio.aws.xray.model.primitives.RequestCount(impl.requestCount())
    override val sampledCount: SampledCount =
      zio.aws.xray.model.primitives.SampledCount(impl.sampledCount())
    override val borrowCount: Optional[BorrowCount] = zio.aws.core.internal
      .optionalFromNullable(impl.borrowCount())
      .map(value => zio.aws.xray.model.primitives.BorrowCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.SamplingStatisticsDocument
  ): zio.aws.xray.model.SamplingStatisticsDocument.ReadOnly = new Wrapper(impl)
}
