package zio.aws.xray.model
import scala.jdk.CollectionConverters._
sealed trait SamplingStrategyName {
  def unwrap: software.amazon.awssdk.services.xray.model.SamplingStrategyName
}
object SamplingStrategyName {
  def wrap(
      value: software.amazon.awssdk.services.xray.model.SamplingStrategyName
  ): zio.aws.xray.model.SamplingStrategyName = value match {
    case software.amazon.awssdk.services.xray.model.SamplingStrategyName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.xray.model.SamplingStrategyName.PARTIAL_SCAN =>
      val r = PartialScan
      r
    case software.amazon.awssdk.services.xray.model.SamplingStrategyName.FIXED_RATE =>
      val r = FixedRate
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.xray.model.SamplingStrategyName {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.SamplingStrategyName =
      software.amazon.awssdk.services.xray.model.SamplingStrategyName.UNKNOWN_TO_SDK_VERSION
  }
  case object PartialScan extends zio.aws.xray.model.SamplingStrategyName {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.SamplingStrategyName =
      software.amazon.awssdk.services.xray.model.SamplingStrategyName.PARTIAL_SCAN
  }
  case object FixedRate extends zio.aws.xray.model.SamplingStrategyName {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.SamplingStrategyName =
      software.amazon.awssdk.services.xray.model.SamplingStrategyName.FIXED_RATE
  }
}
