package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{SegmentDocument, SegmentId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Segment(
    id: Optional[SegmentId] = Optional.Absent,
    document: Optional[SegmentDocument] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.xray.model.Segment = {
    import Segment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.Segment
      .builder()
      .optionallyWith(
        id.map(value => SegmentId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        document.map(value => SegmentDocument.unwrap(value): java.lang.String)
      )(_.document)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.Segment.ReadOnly =
    zio.aws.xray.model.Segment.wrap(buildAwsValue())
}
object Segment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.Segment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.Segment = zio.aws.xray.model
      .Segment(id.map(value => value), document.map(value => value))
    def id: Optional[SegmentId]
    def document: Optional[SegmentDocument]
    def getId: ZIO[Any, AwsError, SegmentId] =
      AwsError.unwrapOptionField("id", id)
    def getDocument: ZIO[Any, AwsError, SegmentDocument] =
      AwsError.unwrapOptionField("document", document)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.Segment
  ) extends zio.aws.xray.model.Segment.ReadOnly {
    override val id: Optional[SegmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.xray.model.primitives.SegmentId(value))
    override val document: Optional[SegmentDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.document())
      .map(value => zio.aws.xray.model.primitives.SegmentDocument(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.Segment
  ): zio.aws.xray.model.Segment.ReadOnly = new Wrapper(impl)
}
