package zio.aws.xray.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.{
  Timestamp,
  NullableBoolean,
  NullableInteger
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Service(
    referenceId: Optional[NullableInteger] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    names: Optional[Iterable[String]] = Optional.Absent,
    root: Optional[NullableBoolean] = Optional.Absent,
    accountId: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    edges: Optional[Iterable[zio.aws.xray.model.Edge]] = Optional.Absent,
    summaryStatistics: Optional[zio.aws.xray.model.ServiceStatistics] =
      Optional.Absent,
    durationHistogram: Optional[Iterable[zio.aws.xray.model.HistogramEntry]] =
      Optional.Absent,
    responseTimeHistogram: Optional[
      Iterable[zio.aws.xray.model.HistogramEntry]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.xray.model.Service = {
    import Service.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.Service
      .builder()
      .optionallyWith(referenceId.map(value => value: Integer))(_.referenceId)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(root.map(value => value: java.lang.Boolean))(_.root)
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        edges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.edges)
      .optionallyWith(summaryStatistics.map(value => value.buildAwsValue()))(
        _.summaryStatistics
      )
      .optionallyWith(
        durationHistogram.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.durationHistogram)
      .optionallyWith(
        responseTimeHistogram.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responseTimeHistogram)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.Service.ReadOnly =
    zio.aws.xray.model.Service.wrap(buildAwsValue())
}
object Service {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.Service] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.Service = zio.aws.xray.model.Service(
      referenceId.map(value => value),
      name.map(value => value),
      names.map(value => value),
      root.map(value => value),
      accountId.map(value => value),
      `type`.map(value => value),
      state.map(value => value),
      startTime.map(value => value),
      endTime.map(value => value),
      edges.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      summaryStatistics.map(value => value.asEditable),
      durationHistogram.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      responseTimeHistogram.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def referenceId: Optional[NullableInteger]
    def name: Optional[String]
    def names: Optional[List[String]]
    def root: Optional[NullableBoolean]
    def accountId: Optional[String]
    def `type`: Optional[String]
    def state: Optional[String]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def edges: Optional[List[zio.aws.xray.model.Edge.ReadOnly]]
    def summaryStatistics
        : Optional[zio.aws.xray.model.ServiceStatistics.ReadOnly]
    def durationHistogram
        : Optional[List[zio.aws.xray.model.HistogramEntry.ReadOnly]]
    def responseTimeHistogram
        : Optional[List[zio.aws.xray.model.HistogramEntry.ReadOnly]]
    def getReferenceId: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("referenceId", referenceId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("names", names)
    def getRoot: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("root", root)
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getEdges: ZIO[Any, AwsError, List[zio.aws.xray.model.Edge.ReadOnly]] =
      AwsError.unwrapOptionField("edges", edges)
    def getSummaryStatistics
        : ZIO[Any, AwsError, zio.aws.xray.model.ServiceStatistics.ReadOnly] =
      AwsError.unwrapOptionField("summaryStatistics", summaryStatistics)
    def getDurationHistogram
        : ZIO[Any, AwsError, List[zio.aws.xray.model.HistogramEntry.ReadOnly]] =
      AwsError.unwrapOptionField("durationHistogram", durationHistogram)
    def getResponseTimeHistogram
        : ZIO[Any, AwsError, List[zio.aws.xray.model.HistogramEntry.ReadOnly]] =
      AwsError.unwrapOptionField("responseTimeHistogram", responseTimeHistogram)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.Service
  ) extends zio.aws.xray.model.Service.ReadOnly {
    override val referenceId: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceId())
      .map(value => value: NullableInteger)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val names: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val root: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.root())
      .map(value => value: NullableBoolean)
    override val accountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val edges: Optional[List[zio.aws.xray.model.Edge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.Edge.wrap(item)
          }.toList
        )
    override val summaryStatistics
        : Optional[zio.aws.xray.model.ServiceStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summaryStatistics())
        .map(value => zio.aws.xray.model.ServiceStatistics.wrap(value))
    override val durationHistogram
        : Optional[List[zio.aws.xray.model.HistogramEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationHistogram())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.HistogramEntry.wrap(item)
          }.toList
        )
    override val responseTimeHistogram
        : Optional[List[zio.aws.xray.model.HistogramEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseTimeHistogram())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.HistogramEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.Service
  ): zio.aws.xray.model.Service.ReadOnly = new Wrapper(impl)
}
