package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{NullableDouble, NullableLong}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceStatistics(
    okCount: Optional[NullableLong] = Optional.Absent,
    errorStatistics: Optional[zio.aws.xray.model.ErrorStatistics] =
      Optional.Absent,
    faultStatistics: Optional[zio.aws.xray.model.FaultStatistics] =
      Optional.Absent,
    totalCount: Optional[NullableLong] = Optional.Absent,
    totalResponseTime: Optional[NullableDouble] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.ServiceStatistics = {
    import ServiceStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.ServiceStatistics
      .builder()
      .optionallyWith(okCount.map(value => value: java.lang.Long))(_.okCount)
      .optionallyWith(errorStatistics.map(value => value.buildAwsValue()))(
        _.errorStatistics
      )
      .optionallyWith(faultStatistics.map(value => value.buildAwsValue()))(
        _.faultStatistics
      )
      .optionallyWith(totalCount.map(value => value: java.lang.Long))(
        _.totalCount
      )
      .optionallyWith(totalResponseTime.map(value => value: java.lang.Double))(
        _.totalResponseTime
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.ServiceStatistics.ReadOnly =
    zio.aws.xray.model.ServiceStatistics.wrap(buildAwsValue())
}
object ServiceStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.ServiceStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.ServiceStatistics =
      zio.aws.xray.model.ServiceStatistics(
        okCount.map(value => value),
        errorStatistics.map(value => value.asEditable),
        faultStatistics.map(value => value.asEditable),
        totalCount.map(value => value),
        totalResponseTime.map(value => value)
      )
    def okCount: Optional[NullableLong]
    def errorStatistics: Optional[zio.aws.xray.model.ErrorStatistics.ReadOnly]
    def faultStatistics: Optional[zio.aws.xray.model.FaultStatistics.ReadOnly]
    def totalCount: Optional[NullableLong]
    def totalResponseTime: Optional[NullableDouble]
    def getOkCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("okCount", okCount)
    def getErrorStatistics
        : ZIO[Any, AwsError, zio.aws.xray.model.ErrorStatistics.ReadOnly] =
      AwsError.unwrapOptionField("errorStatistics", errorStatistics)
    def getFaultStatistics
        : ZIO[Any, AwsError, zio.aws.xray.model.FaultStatistics.ReadOnly] =
      AwsError.unwrapOptionField("faultStatistics", faultStatistics)
    def getTotalCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("totalCount", totalCount)
    def getTotalResponseTime: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("totalResponseTime", totalResponseTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.ServiceStatistics
  ) extends zio.aws.xray.model.ServiceStatistics.ReadOnly {
    override val okCount: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.okCount())
      .map(value => value: NullableLong)
    override val errorStatistics
        : Optional[zio.aws.xray.model.ErrorStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorStatistics())
        .map(value => zio.aws.xray.model.ErrorStatistics.wrap(value))
    override val faultStatistics
        : Optional[zio.aws.xray.model.FaultStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faultStatistics())
        .map(value => zio.aws.xray.model.FaultStatistics.wrap(value))
    override val totalCount: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => value: NullableLong)
    override val totalResponseTime: Optional[NullableDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalResponseTime())
        .map(value => value: NullableDouble)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.ServiceStatistics
  ): zio.aws.xray.model.ServiceStatistics.ReadOnly = new Wrapper(impl)
}
