package zio.aws.xray.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.xray.model.primitives.{
  AnnotationKey,
  Timestamp,
  NullableDouble,
  Integer,
  TraceId,
  NullableBoolean
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TraceSummary(
    id: Optional[TraceId] = Optional.Absent,
    duration: Optional[NullableDouble] = Optional.Absent,
    responseTime: Optional[NullableDouble] = Optional.Absent,
    hasFault: Optional[NullableBoolean] = Optional.Absent,
    hasError: Optional[NullableBoolean] = Optional.Absent,
    hasThrottle: Optional[NullableBoolean] = Optional.Absent,
    isPartial: Optional[NullableBoolean] = Optional.Absent,
    http: Optional[zio.aws.xray.model.Http] = Optional.Absent,
    annotations: Optional[
      Map[AnnotationKey, Iterable[zio.aws.xray.model.ValueWithServiceIds]]
    ] = Optional.Absent,
    users: Optional[Iterable[zio.aws.xray.model.TraceUser]] = Optional.Absent,
    serviceIds: Optional[Iterable[zio.aws.xray.model.ServiceId]] =
      Optional.Absent,
    resourceARNs: Optional[Iterable[zio.aws.xray.model.ResourceARNDetail]] =
      Optional.Absent,
    instanceIds: Optional[Iterable[zio.aws.xray.model.InstanceIdDetail]] =
      Optional.Absent,
    availabilityZones: Optional[
      Iterable[zio.aws.xray.model.AvailabilityZoneDetail]
    ] = Optional.Absent,
    entryPoint: Optional[zio.aws.xray.model.ServiceId] = Optional.Absent,
    faultRootCauses: Optional[Iterable[zio.aws.xray.model.FaultRootCause]] =
      Optional.Absent,
    errorRootCauses: Optional[Iterable[zio.aws.xray.model.ErrorRootCause]] =
      Optional.Absent,
    responseTimeRootCauses: Optional[
      Iterable[zio.aws.xray.model.ResponseTimeRootCause]
    ] = Optional.Absent,
    revision: Optional[Integer] = Optional.Absent,
    matchedEventTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.TraceSummary = {
    import TraceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.TraceSummary
      .builder()
      .optionallyWith(id.map(value => TraceId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(duration.map(value => value: java.lang.Double))(
        _.duration
      )
      .optionallyWith(responseTime.map(value => value: java.lang.Double))(
        _.responseTime
      )
      .optionallyWith(hasFault.map(value => value: java.lang.Boolean))(
        _.hasFault
      )
      .optionallyWith(hasError.map(value => value: java.lang.Boolean))(
        _.hasError
      )
      .optionallyWith(hasThrottle.map(value => value: java.lang.Boolean))(
        _.hasThrottle
      )
      .optionallyWith(isPartial.map(value => value: java.lang.Boolean))(
        _.isPartial
      )
      .optionallyWith(http.map(value => value.buildAwsValue()))(_.http)
      .optionallyWith(
        annotations.map(value =>
          value
            .map({ case (key, value) =>
              (AnnotationKey.unwrap(key): java.lang.String) -> value.map {
                item =>
                  item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.annotations)
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(
        serviceIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceIds)
      .optionallyWith(
        resourceARNs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceARNs)
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(entryPoint.map(value => value.buildAwsValue()))(
        _.entryPoint
      )
      .optionallyWith(
        faultRootCauses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faultRootCauses)
      .optionallyWith(
        errorRootCauses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errorRootCauses)
      .optionallyWith(
        responseTimeRootCauses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responseTimeRootCauses)
      .optionallyWith(revision.map(value => value: java.lang.Integer))(
        _.revision
      )
      .optionallyWith(
        matchedEventTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.matchedEventTime)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.TraceSummary.ReadOnly =
    zio.aws.xray.model.TraceSummary.wrap(buildAwsValue())
}
object TraceSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.TraceSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.TraceSummary =
      zio.aws.xray.model.TraceSummary(
        id.map(value => value),
        duration.map(value => value),
        responseTime.map(value => value),
        hasFault.map(value => value),
        hasError.map(value => value),
        hasThrottle.map(value => value),
        isPartial.map(value => value),
        http.map(value => value.asEditable),
        annotations.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceARNs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        entryPoint.map(value => value.asEditable),
        faultRootCauses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errorRootCauses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        responseTimeRootCauses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        revision.map(value => value),
        matchedEventTime.map(value => value)
      )
    def id: Optional[TraceId]
    def duration: Optional[NullableDouble]
    def responseTime: Optional[NullableDouble]
    def hasFault: Optional[NullableBoolean]
    def hasError: Optional[NullableBoolean]
    def hasThrottle: Optional[NullableBoolean]
    def isPartial: Optional[NullableBoolean]
    def http: Optional[zio.aws.xray.model.Http.ReadOnly]
    def annotations: Optional[
      Map[AnnotationKey, List[zio.aws.xray.model.ValueWithServiceIds.ReadOnly]]
    ]
    def users: Optional[List[zio.aws.xray.model.TraceUser.ReadOnly]]
    def serviceIds: Optional[List[zio.aws.xray.model.ServiceId.ReadOnly]]
    def resourceARNs
        : Optional[List[zio.aws.xray.model.ResourceARNDetail.ReadOnly]]
    def instanceIds
        : Optional[List[zio.aws.xray.model.InstanceIdDetail.ReadOnly]]
    def availabilityZones
        : Optional[List[zio.aws.xray.model.AvailabilityZoneDetail.ReadOnly]]
    def entryPoint: Optional[zio.aws.xray.model.ServiceId.ReadOnly]
    def faultRootCauses
        : Optional[List[zio.aws.xray.model.FaultRootCause.ReadOnly]]
    def errorRootCauses
        : Optional[List[zio.aws.xray.model.ErrorRootCause.ReadOnly]]
    def responseTimeRootCauses
        : Optional[List[zio.aws.xray.model.ResponseTimeRootCause.ReadOnly]]
    def revision: Optional[Integer]
    def matchedEventTime: Optional[Timestamp]
    def getId: ZIO[Any, AwsError, TraceId] =
      AwsError.unwrapOptionField("id", id)
    def getDuration: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("duration", duration)
    def getResponseTime: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("responseTime", responseTime)
    def getHasFault: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("hasFault", hasFault)
    def getHasError: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("hasError", hasError)
    def getHasThrottle: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("hasThrottle", hasThrottle)
    def getIsPartial: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("isPartial", isPartial)
    def getHttp: ZIO[Any, AwsError, zio.aws.xray.model.Http.ReadOnly] =
      AwsError.unwrapOptionField("http", http)
    def getAnnotations: ZIO[Any, AwsError, Map[AnnotationKey, List[
      zio.aws.xray.model.ValueWithServiceIds.ReadOnly
    ]]] = AwsError.unwrapOptionField("annotations", annotations)
    def getUsers
        : ZIO[Any, AwsError, List[zio.aws.xray.model.TraceUser.ReadOnly]] =
      AwsError.unwrapOptionField("users", users)
    def getServiceIds
        : ZIO[Any, AwsError, List[zio.aws.xray.model.ServiceId.ReadOnly]] =
      AwsError.unwrapOptionField("serviceIds", serviceIds)
    def getResourceARNs: ZIO[Any, AwsError, List[
      zio.aws.xray.model.ResourceARNDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceARNs", resourceARNs)
    def getInstanceIds: ZIO[Any, AwsError, List[
      zio.aws.xray.model.InstanceIdDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.xray.model.AvailabilityZoneDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getEntryPoint
        : ZIO[Any, AwsError, zio.aws.xray.model.ServiceId.ReadOnly] =
      AwsError.unwrapOptionField("entryPoint", entryPoint)
    def getFaultRootCauses
        : ZIO[Any, AwsError, List[zio.aws.xray.model.FaultRootCause.ReadOnly]] =
      AwsError.unwrapOptionField("faultRootCauses", faultRootCauses)
    def getErrorRootCauses
        : ZIO[Any, AwsError, List[zio.aws.xray.model.ErrorRootCause.ReadOnly]] =
      AwsError.unwrapOptionField("errorRootCauses", errorRootCauses)
    def getResponseTimeRootCauses: ZIO[Any, AwsError, List[
      zio.aws.xray.model.ResponseTimeRootCause.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "responseTimeRootCauses",
      responseTimeRootCauses
    )
    def getRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("revision", revision)
    def getMatchedEventTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("matchedEventTime", matchedEventTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.TraceSummary
  ) extends zio.aws.xray.model.TraceSummary.ReadOnly {
    override val id: Optional[TraceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.xray.model.primitives.TraceId(value))
    override val duration: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: NullableDouble)
    override val responseTime: Optional[NullableDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.responseTime())
      .map(value => value: NullableDouble)
    override val hasFault: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasFault())
      .map(value => value: NullableBoolean)
    override val hasError: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasError())
      .map(value => value: NullableBoolean)
    override val hasThrottle: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasThrottle())
      .map(value => value: NullableBoolean)
    override val isPartial: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPartial())
      .map(value => value: NullableBoolean)
    override val http: Optional[zio.aws.xray.model.Http.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.http())
        .map(value => zio.aws.xray.model.Http.wrap(value))
    override val annotations: Optional[
      Map[AnnotationKey, List[zio.aws.xray.model.ValueWithServiceIds.ReadOnly]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.annotations())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.xray.model.primitives
              .AnnotationKey(key) -> value.asScala.map { item =>
              zio.aws.xray.model.ValueWithServiceIds.wrap(item)
            }.toList
          })
          .toMap
      )
    override val users: Optional[List[zio.aws.xray.model.TraceUser.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.users())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.TraceUser.wrap(item)
          }.toList
        )
    override val serviceIds
        : Optional[List[zio.aws.xray.model.ServiceId.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.ServiceId.wrap(item)
          }.toList
        )
    override val resourceARNs
        : Optional[List[zio.aws.xray.model.ResourceARNDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceARNs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.ResourceARNDetail.wrap(item)
          }.toList
        )
    override val instanceIds
        : Optional[List[zio.aws.xray.model.InstanceIdDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.InstanceIdDetail.wrap(item)
          }.toList
        )
    override val availabilityZones
        : Optional[List[zio.aws.xray.model.AvailabilityZoneDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.AvailabilityZoneDetail.wrap(item)
          }.toList
        )
    override val entryPoint: Optional[zio.aws.xray.model.ServiceId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entryPoint())
        .map(value => zio.aws.xray.model.ServiceId.wrap(value))
    override val faultRootCauses
        : Optional[List[zio.aws.xray.model.FaultRootCause.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faultRootCauses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.FaultRootCause.wrap(item)
          }.toList
        )
    override val errorRootCauses
        : Optional[List[zio.aws.xray.model.ErrorRootCause.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorRootCauses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.ErrorRootCause.wrap(item)
          }.toList
        )
    override val responseTimeRootCauses
        : Optional[List[zio.aws.xray.model.ResponseTimeRootCause.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseTimeRootCauses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.ResponseTimeRootCause.wrap(item)
          }.toList
        )
    override val revision: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => value: Integer)
    override val matchedEventTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.matchedEventTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.TraceSummary
  ): zio.aws.xray.model.TraceSummary.ReadOnly = new Wrapper(impl)
}
