package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UnprocessedStatistics(
    ruleName: Optional[String] = Optional.Absent,
    errorCode: Optional[String] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.UnprocessedStatistics = {
    import UnprocessedStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.UnprocessedStatistics
      .builder()
      .optionallyWith(ruleName.map(value => value: java.lang.String))(
        _.ruleName
      )
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.UnprocessedStatistics.ReadOnly =
    zio.aws.xray.model.UnprocessedStatistics.wrap(buildAwsValue())
}
object UnprocessedStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.UnprocessedStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.UnprocessedStatistics =
      zio.aws.xray.model.UnprocessedStatistics(
        ruleName.map(value => value),
        errorCode.map(value => value),
        message.map(value => value)
      )
    def ruleName: Optional[String]
    def errorCode: Optional[String]
    def message: Optional[String]
    def getRuleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.UnprocessedStatistics
  ) extends zio.aws.xray.model.UnprocessedStatistics.ReadOnly {
    override val ruleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleName())
      .map(value => value: String)
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.UnprocessedStatistics
  ): zio.aws.xray.model.UnprocessedStatistics.ReadOnly = new Wrapper(impl)
}
